% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_objectives.r
\name{get_objectives}
\alias{get_objectives}
\title{Retrieve Objectives set for waterbodies}
\usage{
get_objectives(ea_name = NULL, column = NULL,
  level = "Overall Water Body", year = NULL, type = NULL)
}
\arguments{
\item{ea_name}{A string representing the description (\code{name} for 
\code{OC}, \code{MC} or \code{RBD} level downloads or \code{WBID} for 
individual waterbodies) of the features to be extracted. For example 
to extract data for the whole of the Humber RBD, this would be "Humber"; 
also see examples. Must be an exact match to the values used in the EA 
database. Use the \code{\link{search_names}} function to search for 
specific values.}

\item{column}{The column to be searched. Possible options are
\code{WBID} (waterbody id), \code{OC} (Operational Catchment), \code{MC}
(Management Catchment) and \code{RBD} (River Basin District)}

\item{level}{The level within the WFD quality classification elements that 
objectives have been set at. For full details of the hierarchy of elements 
within the classification used, see \url{https://environment.data.gov.uk/catchment-planning/help#help-classification-hierarchy}.

Defaults to 'Overall Water Body'. Possible values for the different levels 
retrieved by the function are shown below.

\tabular{ccc}{
 \strong{Level 1} \tab \strong{Level 2} \tab \strong{Level 4}\cr
Ecological \tab Biological quality elements \tab Overall Water Body \cr
Chemical \tab Chemical Status element \tab -\cr
Quantitative \tab Hydromorphological Supporting Elements \tab -\cr
 - \tab Other Substances \tab -\cr
 - \tab Physico-chemical quality elements \tab -\cr
 - \tab Priority hazardous substances \tab -\cr
 - \tab Priority substances \tab -\cr
 - \tab Quantitative Status element \tab - \cr
 - \tab Specific pollutants \tab -\cr
 - \tab Supporting elements \tab -\cr
}}

\item{year}{The year that objectives are set for, either 2015, 
2021, 2027, 2040 or 2050. If not given then objectives for all years 
are returned. Note that objectives may not be set for all years.}

\item{type}{Type of waterbody to be extracted. For Operational/Management
catchment level or RBD level queries, the data can also be subset by
waterbody type. Possible values are \code{River}, \code{Lake},
\code{GroundWaterBody}, \code{TransitionalWater} or \code{CoastalWater}.}
}
\value{
An object of class \code{cde_df} containing the details 
of the objectives set for the specified set of waterbodies.
For details of the meaning of the the different columns returned, 
see \url{https://docs.ropensci.org/cde/articles/cde-output-reference.html}.
}
\description{
Retrieves details of objectives set for waterbodies in terms
of predicted classification from EA Catchment Data Explorer site.
Data can be retrieved by specifying waterbody id
(\code{WBID}), Management Catchment (\code{MC}), Operational
Catchment (\code{OC}) or River Basin District (\code{RBD}).
Start year (\code{startyr}) and end year (\code{endyr}) allow
specific timeranges to be downloaded.
For Management Catchment (\code{MC}), Operational
Catchment (\code{OC}) or River Basin District (\code{RBD}) level
downloads, waterbody \code{type} can also be specified to allow
extraction of specific waterbody types (River, Lake etc).
}
\examples{
# get all objectives set for waterbody GB112071065700
get_objectives(ea_name="GB112071065700", column="WBID")

# get the objectives set for Lakes in the Humber RBD, for the year 2021
get_objectives(ea_name="Humber", column="RBD", year=2021, type="Lake")

# get the objectives set for Rivers in the Avon Warwickshire
# Management Catchment in relation to Chemical status
get_objectives(ea_name="Avon Warwickshire", column="MC", level="Chemical", type="River")

}
