% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrControl.R
\name{cdfqr.control}
\alias{cdfqr.control}
\title{Control Optimization Parameters for CDF-Quantile Probability Distributions}
\usage{
cdfqr.control(method = "BFGS", maxit = 5000, trace = FALSE)
}
\arguments{
\item{method}{Characters string specifying the method argument passed to \link[stats]{optim}.}

\item{maxit}{Integer specifying the maxit argument (maximal number of iterations) passed to \link[stats]{optim}.}

\item{trace}{Logical or integer controlling whether tracing information on the progress of the optimization should be produced}
}
\value{
A list with the arguments specified.
}
\description{
Control Optimization Parameters for CDF-Quantile Probability Distributions.
}
\examples{

data(cdfqrExampleData)
fit <- cdfquantreg(crc99 ~ vert | confl, 't2', 't2', 
data = JurorData,control = cdfqr.control(trace = TRUE))
}
