% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{feat}
\alias{feat}
\title{Feature plots: Color gene expression in 2D embeddings}
\usage{
feat(obj, features, fast = NULL, verbose = TRUE, ...)
}
\arguments{
\item{obj}{A cellpypes object, see section \strong{cellpypes Objects} below.}

\item{features}{A vector of genes (features) to colour by.}

\item{fast}{Set this to TRUE if you want fast plotting in spite of many cells
(using the scattermore package). If NULL (default), cellpypes decides
automatically and fast plotting is done for more than 10k cells.}

\item{verbose}{feat ignores gene names not present in your object and
warns you about them by default. \code{verbose}=FALSE will suppress the warning
(not recommended in interactive use).}

\item{...}{Arguments passed to cowplot's \link[cowplot]{plot_grid} function,
for example ncol or rel_widths.}
}
\value{
A ggplot object (assembled by cowplot).
}
\description{
Highlight gene expression in UMAP embeddings, for example.
}
\section{cellpypes Objects}{

A cellpypes object is a \link[base]{list} with four slots:
\itemize{
\item{\code{raw }}{(sparse) matrix with genes in rows, cells in columns}
\item{\code{totalUMI }}{the colSums of obj$raw}
\item{\code{embed }}{two-dimensional embedding of the cells, provided as data.frame
or tibble with two columns and one row per cell.}
\item{\code{neighbors }}{index matrix with one row per cell and k columns, where
k is the number of nearest neighbors (we recommend 15<k<100, e.g. k=50).
Here are two ways to get the neighbors index matrix:
\itemize{
\item Use \code{find_knn(featureMatrix)$idx}, where featureMatrix could be
principal components, latent variables or normalized genes (features in
rows, cells in columns).
\item use \code{as(seurat@graphs[["RNA_nn"]], "dgCMatrix")> .1} to extract
the kNN
graph computed on RNA. The \code{> .1} ensures this also works with RNA_snn,
wknn/wsnn or any other
available graph – check with \code{names(seurat@graphs)}.
}
}
}
}

\examples{
feat(simulated_umis, "CD3E")
}
