% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{applyStaggered}
\alias{applyStaggered}
\title{Compute a Measure on a Track in a Staggered Fashion}
\usage{
applyStaggered(x, measure, matrix = FALSE, min.segments = 1)
}
\arguments{
\item{x}{the track for which the measure is to be computed.}

\item{measure}{the measure that is to be computed.}

\item{matrix}{a logical indicating whether the whole matrix of values for
the measure for each of the input track's subtracks is to be returned.
Otherwise only the mean is returned.}

\item{min.segments}{the number of segments that each regarded subtrack
should at least consist of. Typically, this value would be set to the
minimum number of segments that a (sub)track must have in order for the
measure to be decently computed. For example, at least two segments are needed
to compute the \code{\link{overallAngle}}.}
}
\value{
If \code{matrix} is set, a matrix with the values of the measure for
all the input track's subtracks is returned. The value of this matrix at
position \code{[i, j]} corresponds to the subtrack that starts with the input track's
\eqn{j}th point and ends at its \eqn{i}th. Thus, with increasing column number,
the regarded subtrack's starting point is advanced on the original track,
and the values for increasingly long subtracks starting from this point can
be found columnwise below the main diagonal, respectively.
If `matrix` is not set, the mean over the values of the measure for all
subtracks of at least `min.segments` segments is retruned.
}
\description{
Computes a measure on all subtracks of a track and return them either
as a matrix or return their mean.
}
\details{
The measure is computed for each of the input track's subtracks of
length at least \code{min.segments}, and the resulting values are either
returned in a matrix (if \code{matrix} is set), or their mean is returned.
The computed matrix is symmetric since the direction along which a
track is traversed is assumed not to matter. The values at
\code{[i, i + j]}, where j is a nonnegative integer with
\eqn{j < }\code{min.segments}, (with the default value \code{min.segments=1}
this is exactly the main diagonal) are set to \code{NA}.
}
\examples{
## Compute the staggered matrix for overallAngle applied to all long enough
## subtracks of the first T cell track
applyStaggered(TCells[[1]], overallAngle, matrix=TRUE, min.segments = 2)
}
