% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_tree-rpart.R
\name{survival_prob_survbagg}
\alias{survival_prob_survbagg}
\title{A wrapper for survival probabilities with \code{survbagg} models}
\usage{
survival_prob_survbagg(object, new_data, time)
}
\arguments{
\item{object}{A model from \code{ipred::bagging()}.}

\item{new_data}{Data for prediction.}

\item{time}{A vector of prediction times.}
}
\value{
A vctrs list of tibbles.
}
\description{
A wrapper for survival probabilities with \code{survbagg} models
}
\examples{
library(ipred)
bagged_tree <- bagging(Surv(time, status) ~ age + ph.ecog, data = lung)
survival_prob_survbagg(bagged_tree, lung[1:3, ], time = 100)
}
\keyword{internal}
