% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost_tree-mboost.R
\name{survival_prob_mboost}
\alias{survival_prob_mboost}
\title{A wrapper for survival probabilities with mboost models}
\usage{
survival_prob_mboost(object, new_data, eval_time, time = deprecated())
}
\arguments{
\item{object}{A parsnip \code{model_fit} object resulting from \link[parsnip:details_boost_tree_mboost]{boost_tree() with engine = "mboost"}.}

\item{new_data}{Data for prediction.}

\item{eval_time}{A vector of integers for prediction times.}

\item{time}{Deprecated in favor of \code{eval_time}. A vector of integers for prediction times.}
}
\value{
A tibble with a list column of nested tibbles.
}
\description{
A wrapper for survival probabilities with mboost models
}
\examples{
\dontshow{if (rlang::is_installed("mboost")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mod <- boost_tree() \%>\%
  set_engine("mboost") \%>\%
  set_mode("censored regression") \%>\%
  fit(Surv(time, status) ~ ., data = lung)
survival_prob_mboost(mod, new_data = lung[1:3, ], eval_time = 300)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
