% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotorEqual.R
\name{rotorEqual}
\alias{rotorEqual}
\title{Balance Tubes of Equal Mass}
\usage{
rotorEqual(n, k, seed = 2019)
}
\arguments{
\item{n}{an integer, the number of rotor buckets.}

\item{k}{an integer, the number of tubes.}

\item{seed}{an integer, the seed for random number generation. Setting a seed
ensures the reproducibility of the result. See \code{\link{set.seed}} for
more details.}
}
\value{
\code{rotorEqual} returns a list with two components:
  \item{\code{loaded}}{a vector containing the positions of rotor buckets
  that must be loaded.} \item{\code{empty}}{a vector containing the positions
  of rotor buckets that must be empty.} \code{rotorEqual} also plots a
  schematic diagram of the centrifuge rotor.
}
\description{
\code{rotorEqual} returns the positions of rotor buckets that must be loaded
or empty to balance tubes of equal mass.
}
\details{
The number of rotor buckets \code{n} ranges from \code{4} to
  \code{48}. The number of tubes \code{k} must be greater than \code{0} and
  smaller than the number of rotor buckets \code{n}.
}
\examples{
rotorEqual(30, 11)
rotorEqual(30, 19)

}
\references{
Sivek G. On vanishing sums of distinct roots of unity. Integers.
  2010;10(3):365-8. \cr \cr Peil O, Hauryliuk V. A new spin on spinning your
  samples: balancing rotors in a non-trivial manner. arXiv preprint
  arXiv:1004.3671. 2010 Apr 21.
}
\seealso{
\code{\link{rotorCheck}} for checking centrifuge rotors and
  \code{\link{rotorUnequal}} for balancing tubes of unequal mass.
}
