% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_game_info}
\alias{cfbd_game_info}
\title{\strong{Get results information from games.}}
\usage{
cfbd_game_info(
  year,
  week = NULL,
  season_type = "regular",
  team = NULL,
  home_team = NULL,
  away_team = NULL,
  conference = NULL,
  game_id = NULL,
  quarter_scores = FALSE
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format(\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week - values from 1-15, 1-14 for seasons pre-playoff (i.e. 2013 or earlier)}

\item{season_type}{(\emph{String} default regular): Select Season Type: regular, postseason, or both}

\item{team}{(\emph{String} optional): D-I Team}

\item{home_team}{(\emph{String} optional): Home D-I Team}

\item{away_team}{(\emph{String} optional): Away D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference\cr
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC\cr
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC\cr}

\item{game_id}{(\emph{Integer} optional): Game ID filter for querying a single game}

\item{quarter_scores}{(\emph{Logical} default FALSE): This is a parameter to return the
list columns that give the score at each quarter: \code{home_line_scores} and \code{away_line_scores}.\cr
I have defaulted the parameter to false so that you will not have to go to the trouble of dropping it.}
}
\value{
\code{\link[=cfbd_game_info]{cfbd_game_info()}} - A data frame with 22 variables:
\describe{
\item{\code{game_id}: integer.}{Referencing game id.}
\item{\code{season}: integer.}{Season of the game.}
\item{\code{week}: integer.}{Game week.}
\item{\code{season_type}: character.}{Season type of the game.}
\item{\code{start_date}: character.}{Game date.}
\item{\code{start_time_tbd}: logical.}{TRUE/FALSE flag for if the game's start time is to be determined.}
\item{\code{neutral_site}: logical.}{TRUE/FALSE flag for the game taking place at a neutral site.}
\item{\code{conference_game}: logical.}{TRUE/FALSE flag for this game qualifying as a conference game.}
\item{\code{attendance}: integer.}{Reported attendance at the game.}
\item{\code{venue_id}: integer.}{Referencing venue id.}
\item{\code{venue}: character.}{Venue name.}
\item{\code{home_id}: integer.}{Home team referencing id.}
\item{\code{home_team}: character.}{Home team name.}
\item{\code{home_conference}: character.}{Home team conference.}
\item{\code{home_points}: integer.}{Home team points.}
\item{\code{home_post_win_prob}: character.}{Home team post-game win probability.}
\item{\code{home_pregame_elo}: character.}{Home team pre-game ELO rating.}
\item{\code{home_postgame_elo}: character.}{Home team post-game ELO rating.}
\item{\code{away_id}: integer.}{Away team referencing id.}
\item{\code{away_team}: character.}{Away team name.}
\item{\code{away_conference}: character.}{Away team conference.}
\item{\code{away_points}: integer.}{Away team points.}
\item{\code{away_post_win_prob}: character.}{Away team post-game win probability.}
\item{\code{away_pregame_elo}: character.}{Away team pre-game ELO rating.}
\item{\code{away_postgame_elo}: character.}{Away team post-game ELO rating.}
\item{\code{excitement_index}: character.}{Game excitement index.}
\item{\code{highlights}: character.}{Game highlight urls.}
\item{\code{notes}: character.}{Game notes.}
}
}
\description{
\strong{Get results information from games.}
}
\examples{
\donttest{
  cfbd_game_info(2018, week = 1)

  cfbd_game_info(2018, week = 7, conference = "Ind")

  # 7 OTs LSU @ TAMU
  cfbd_game_info(2018, week = 13, team = "Texas A&M", quarter_scores = TRUE)
}
}
\keyword{Game}
\keyword{Info}
