% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfd.mean.R
\name{cfd.mean}
\alias{cfd.mean}
\title{Mean Decomposition: parametric version}
\usage{
cfd.mean(
  formula.y,
  formula.m,
  mediator,
  group,
  data,
  family.y = "binomial",
  family.m = "binomial",
  bs.size = 1000,
  mc.size = 50,
  alpha = 0.05,
  sample.resid = FALSE,
  print.iteration = FALSE
)
}
\arguments{
\item{formula.y}{the \code{\link{formula}} for the multivariable model (see \code{\link{glm}}) for the outcome Y.}

\item{formula.m}{the \code{\link{formula}} for the multivariable model (see \code{\link{glm}}) for the mediator M.}

\item{mediator}{the column name of the mediator M.}

\item{group}{column name of a factor variable containing the group identifier.}

\item{data}{a data frame containing the variables in the model.}

\item{family.y}{a description of the error distribution to be used in the model, see \code{\link{family}} for details. For the outcome variable any member of the \code{glm} family can be used.}

\item{family.m}{a description of the error distribution to be used in the model, see \code{\link{family}} for details. For the mediator, currently \code{gaussian}, \code{binomial} and \code{poisson} are supported.}

\item{bs.size}{the number of bootstrap iterations to be performed.}

\item{mc.size}{the number of Monte Carlo iterations to be performed (more = more MC error reduction).}

\item{alpha}{the alpha level used to construct confidence intervals (0.05 = 95 percent confidence interval).}

\item{sample.resid}{if the \code{mediator} is Gaussian, should the simulation sample from the residuals of the linear regression model of the mediator to approximate the empirical distribution of the mediator in the simulation (Monte Carlo integration) (if so, set to \code{TRUE}), or should it sample from a Gaussian distribution with the standard deviation of the mediator? If the true distribution of the continuous mediator is not very Gaussian, the former may be preferred.}

\item{print.iteration}{print the bootstrap iteration}
}
\value{
\code{out_nc_m} returns the mean level of the mediator under the natural course, which is a value that should be close to the empirically observed value of the mediator for each group. \code{out_nc_quantile} provides the \code{alpha/2} and \code{1-alpha/2} bootstrap quantiles for this mean (AKA bootstrap percentile confidence intervals). \code{out_nc_y} and \code{out_nc_quantile_y} provide the corresponding values, but then for the outcome variable Y. Similarly, \code{out_cf_m}, \code{out_cf_quantile_m},\code{out_cf_y}, and \code{out_cf_quantile_y} provide the corresponding values for the counterfactual scenario where the mediators of the groups are equalized. \code{mediation} returns the proportion mediated by setting the intervened on mediator to be equal in level to the reference group and \code{mediation_quantile} returns the 1-alpha confidence interval. \code{mc_conv_info_m} and \code{mc_conv_info_y} provide information that can help determine the number of Monte Carlo and Bootstrap iterations needed to achieve stability. See the \code{Examples} for more information.
}
\description{
Decompose the mean difference in outcome Y between groups.
}
\examples{
set.seed(100)
# the decomposition functions in our package are computationally intensive
# to make the example run quick, I perform it on a subsample (n=500) of the data:
cfd.example.sample <- cfd.example.data[sample(500),]
mean.results.1 <- cfd.mean(formula.y='out.gauss ~ SES + med.gauss + med.binom + age',
                           formula.m='med.gauss ~ SES + age',
                           mediator='med.gauss',
                           group='SES',
                           data=cfd.example.sample,
                           family.y='gaussian',
                           family.m='gaussian',
                           bs.size=50,
                           mc.size=10,
                           alpha=0.05)
# also note that normally we would recommend an bs.size of 250+
# and an mc.size of 50+
# let's interpret the output of this function:
mean(mean.results.1$out_nc_y[,2] - mean.results.1$out_nc_y[,1])
# and after giving the gaussian mediator of SES group 2 the distribution of the one in group 1
# the difference becomes:
mean(mean.results.1$out_cf_y[,2] - mean.results.1$out_nc_y[,1])
# so the \% of the outcome Y that is due to differences between the two SES groups
# in the gaussian mediator is
mean(1-(mean.results.1$out_cf_y[,2] - mean.results.1$out_nc_y[,1]) /
(mean.results.1$out_nc_y[,2] - mean.results.1$out_nc_y[,1]))
# we can also get this number, and the one from the comparison of the other SES group
# with group 1, straight from the object
mean.results.1$mediation
# and we can get the 1-alpha CI for each:
mean.results.1$mediation_quantile
# see README.md for a more detailed description of the functions in this package.
}
