% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_bib.R
\name{write_bib}
\alias{write_bib}
\title{Create a .bib file}
\usage{
write_bib(x, file = NULL, append = FALSE, verbose = TRUE, ascii = FALSE)
}
\arguments{
\item{x}{A \code{bibentry} object created with:
\itemize{
\item \code{\link[=cff_to_bibtex]{cff_to_bibtex()}}
\item \code{\link[=citation]{citation()}} or \code{\link[=bibentry]{bibentry()}}
}}

\item{file}{Name of the file. If \code{NULL} it would display the lines to be
written.}

\item{append}{Whether to append the entries to an existing file or not.}

\item{verbose}{Display informative messages}

\item{ascii}{Whether to write the entries using ASCII characters only or not.}
}
\value{
Writes an \code{.bib} file specified on \code{file} parameter and the
equivalent \code{Bibtex} object created with \code{\link[utils:toLatex]{utils::toBibtex()}}. It also
(invisibly) returns the \code{bibentry} object that has been written to the file.
}
\description{
Creates a .bib file from a \code{bibentry} object(s)
}
\details{
For security reasons, if the file already exists the function would create
a backup copy on the same directory.
}
\examples{

bib <- bibentry("Misc",
  title = "My title",
  author = "Fran Pérez"
)

write_bib(bib)

write_bib(bib, ascii = TRUE)
}
\seealso{
\code{vignette("bibtex_cff", "cffr")}, \code{\link[knitr:write_bib]{knitr::write_bib()}} and the
following packages:
\itemize{
\item \href{https://github.com/ropensci/bibtex}{bibtex} package.
\item \href{https://github.com/ropensci/RefManageR}{RefManageR} package.
\item \href{https://github.com/GeoBosh/rbibutils/}{rbibutils}
}

Other bibtex: 
\code{\link{cff_from_bibtex}()},
\code{\link{cff_to_bibtex}()},
\code{\link{encoded_utf_to_latex}()},
\code{\link{write_citation}()}
}
\concept{bibtex}
