% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf_variable.R
\name{CounterfactualVariable}
\alias{CounterfactualVariable}
\alias{cf}
\title{Counterfactual Variable}
\usage{
CounterfactualVariable(var, obs = integer(0), int = integer(0))

cf(var, obs = integer(0), int = integer(0))
}
\arguments{
\item{var}{A character vector of length one naming
the variable (i.e., \eqn{Y}).}

\item{obs}{An integer vector of length one or zero. If given, denotes
the observed value of \code{var} (i.e., \eqn{Y = 0})}

\item{int}{A named integer vector where the names correspond to the variables
intervened on (i.e., \eqn{X}) and values to the value assignments
(their levels).}
}
\value{
An object of class \code{CounterfactualVariable}.
}
\description{
Defines a counterfactual variable \eqn{y_x}.
}
\details{
Assume that \eqn{Y} is a single variable and \eqn{X} is a vector
of variables. Here, The notation \eqn{y_x} means that the variable
\eqn{Y} (\code{var}) attains the value \eqn{y} (\code{obs}) under the
intervention \eqn{do(X = x)} (\code{int}).

Note that different values of \code{obs} for a two variables with the same \code{var}
and the same \code{int} do not denote their actual values, but the levels
(i.e., \code{obs = 0} is different from \code{obs = 1}, but the variables do not
actually attain values 0 and 1). For more information about the
\eqn{do}-operator, see Pearl (2009). The shortcut alias \code{cf} can also
be used to construct counterfactual variables variables.
}
\examples{
# Y without an assigned value or any interventions
cf("Y")

# Y with a value assignment y, but no interventions
cf("Y", 0)

# Y with a different value y', but no interventions
cf("Y", 1)

# Y with the same value as the previous under the intervention do(X = x)
cf("Y", 1, c("X" = 0))

# Y with yet another value y'', under the intervention
# do(X = x', Z = z), i.e., the intervention on X has a different value
# than the previous (x != x') and Z is also assigned the value z
cf("Y", 2, c("X" = 1, "Z" = 0))
}
\references{
Pearl, J. (2009) \emph{Causality: Models, Reasoning, and Inference}. Cambridge
University Press, 2nd edition.
}
\seealso{
\code{\link[=CounterfactualConjunction]{CounterfactualConjunction()}}
}
