% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_mean.R
\name{CV.search.DP.univar}
\alias{CV.search.DP.univar}
\title{Grid search for dynamic programming to select the tuning parameter through Cross-Validation.}
\usage{
CV.search.DP.univar(y, gamma_set, delta)
}
\arguments{
\item{y}{A \code{numeric} vector of observations.}

\item{gamma_set}{A \code{numeric} vector of candidate tuning parameter associated with the \eqn{l_0} penalty.}

\item{delta}{A positive \code{integer} scalar of minimum spacing.}
}
\value{
A \code{list} with the following structure:
 \item{cpt_hat}{A list of vector of estimated change points (sorted in strictly increasing order).}
 \item{K_hat}{A list of scalar of number of estimated change points.}
 \item{test_error}{A list of vector of testing errors.}
 \item{train_error}{A list of vector of training errors.}
}
\description{
Perform grid search for dynamic programming to select the tuning parameter through Cross-Validation.
}
\examples{
set.seed(0)
cpt_true = c(20, 50, 170)
y = rnorm(300) + c(rep(0,20),rep(2,30),rep(0,120),rep(2,130))
gamma_set = 1:5
DP_result = CV.search.DP.univar(y, gamma_set, delta = 5)
min_idx = which.min(DP_result$test_error)
cpt_hat = unlist(DP_result$cpt_hat[min_idx])
Hausdorff.dist(cpt_hat, cpt_true)
}
\references{
Wang, Yu and Rinaldo (2020) <doi:10.1214/20-EJS1710>
}
\author{
Daren Wang & Haotian Xu
}
