% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_mean_robust.R
\name{WBS.uni.rob}
\alias{WBS.uni.rob}
\title{Robust wild binary segmentation for univariate mean change points detection.}
\usage{
WBS.uni.rob(y, s, e, Alpha, Beta, K = 1.345, delta, level = 0)
}
\arguments{
\item{y}{A \code{numeric} vector of observations.}

\item{s}{A \code{numeric} scalar representing the starting index of an interval.}

\item{e}{A \code{numeric} scalar representing the ending index of an interval.}

\item{Alpha}{An \code{integer} vector of starting indices of random intervals.}

\item{Beta}{An \code{integer} vector of ending indices of random intervals.}

\item{K}{A \code{numeric} scalar representing the robustification parameter in the Huber loss.}

\item{delta}{A positive \code{integer} scalar of minimum spacing.}

\item{level}{Should be fixed as 0.}
}
\value{
An object of \code{\link[base]{class}} "BS", which is a \code{list} with the following structure:
 \item{S}{A vector of estimated change points (sorted in strictly increasing order).}
 \item{Dval}{A vector of values of CUSUM statistic based on KS distance.}
 \item{Level}{A vector representing the levels at which each change point is detected.}
 \item{Parent}{A matrix with the starting indices on the first row and the ending indices on the second row.}
}
\description{
Perform a robust version of the wild binary segmentation method using Huber loss.
}
\references{
Fearnhead & Rigaill (2019) <doi:10.1080/01621459.2017.1385466>.
}
\seealso{
\code{\link{thresholdBS}} for obtaining change points estimation.
}
\author{
Mengchu Li & Haotian Xu
}
