% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_with_missing.R
\name{softImpute.network.missing}
\alias{softImpute.network.missing}
\title{Estimate graphon matrix by soft-impute for independent adjacency matrices with missing values.}
\usage{
softImpute.network.missing(
  data_incomplete_list,
  eta_list,
  lambda,
  a,
  it_max = 10000
)
}
\arguments{
\item{data_incomplete_list}{A \code{list} of adjacency matrices (with entries being 0 or 1) with missing values being coercing to 0.}

\item{eta_list}{A \code{list} of matrices associated with data_incomplete_list, each matrix indicates the missing entries in corresponding adjacency matrix.}

\item{lambda}{A \code{numeric} scalar of thresholding parameter for leading singular value in the soft-impute algorithm.}

\item{a}{A \code{numeric} scalar of truncation parameter in the soft-impute algorithm.}

\item{it_max}{An \code{integer} scalar of maximum iteration for the soft-impute algorithm.}
}
\value{
Estimated graphon matrix
}
\description{
Estimate graphon matrix by soft-impute for independent adjacency matrices with missing values.
}
\references{
Dubey, Xu and Yu (2021) <arxiv:2110.06450>
}
\author{
Haotian Xu
}
