#' ChatGPT: Refactor Code
#'
#' @param code The code to be refactored by ChatGPT.
#'
#' @examples
#' \dontrun{
#' cat(refactor_code("i <- 10\nwhile (i > 0) {\n  i <- i - 1\n  print(i)\n}"))
#' }
#'
#' @return A character value with the response generated by ChatGPT.
#'
#' @export
#'
refactor_code <- function(code) {
  prompt <- paste0('Refactor the following R code, returning valid R code: "', code, '"')
  trimws(sapply(gpt_get_completions(prompt)$choices, function(x) x$text))
}
