% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{bin}
\alias{bin}
\title{A sometimes cheaper but argument richer alternative to \code{.bincode()}}
\usage{
bin(
  x,
  breaks,
  left_closed = TRUE,
  include_endpoint = FALSE,
  include_oob = FALSE,
  codes = TRUE
)
}
\arguments{
\item{x}{A numeric vector.}

\item{breaks}{A numeric vector of breaks.}

\item{left_closed}{Should intervals be left-closed (and right-open)?
Default is \code{TRUE}. If \code{FALSE} they are left-open (and right-closed).}

\item{include_endpoint}{Equivalent to \code{include.lowest} in  \code{?.bincode}.}

\item{include_oob}{Should out-of-bounds interval be included?
Default is \code{FALSE}. This is the equivalent of adding \code{Inf} as
the last value of the breaks, or \code{-Inf} as the
first value of the breaks if \code{left_closed = FALSE}. When \code{TRUE},
this essentially becomes \code{findInterval()}.}

\item{codes}{Should an integer vector indicating which bin the values
fall into be returned? Default is \code{TRUE}. If \code{FALSE} the
start values of the respective bin intervals are returned, i.e the
corresponding breaks.}
}
\value{
Either an integer vector of codes indicating which bin the values fall
into, or the start of the intervals for which each value falls into.
}
\description{
When \code{x} is an integer vector, \code{bin()} is cheaper than \code{.bincode()} as
no coercion to a double vector occurs. This alternative also has more
arguments that allow you to return the start values of the binned vector,
as well as including out-of-bounds intervals.
}
\seealso{
\link{get_breaks} \link{as_discrete}
}
