% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int.R
\name{check_int}
\alias{check_int}
\title{Check Int}
\usage{
check_int(x, coerce = FALSE, x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce a numeric (dbl) whole number to an int and drop attributes including names.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is a int (non-missing integer scalar with no attributes including names).
}
\examples{
check_int(1, error = FALSE)
check_int(1L, error = FALSE)
check_int(1:2, error = FALSE)
}
\seealso{
\code{\link{check_scalar}}
}
