% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_cheem_lists.r
\name{subset_cheem}
\alias{subset_cheem}
\title{Subset a cheem list}
\usage{
subset_cheem(cheem_ls, rownumbers = 1:500)
}
\arguments{
\item{cheem_ls}{The return of a \code{cheem_ls()} call.}

\item{rownumbers}{A vector of the numeric index of rownumbers to keep.
To use a logical index, pass it to \code{which()},
eg. \code{idx <- which(mtcars$mpg > 30)}.}
}
\value{
A subset of the supplied cheem_ls.
}
\description{
Given a numerical index of rownumbers of the original data, subset the
correct elements of a cheem list.
}
\examples{
library(cheem)

## Classification setup
X    <- spinifex::penguins_na.rm[, 1:4]
Y    <- spinifex::penguins_na.rm$species
clas <- spinifex::penguins_na.rm$species

## Cheem
peng_chm <- cheem_ls(X, Y, penguin_xgb_shap, penguin_xgb_pred, clas,
                     label = "Penguins, xgb, shapviz")
lapply(peng_chm, NROW)

## subset a cheem list
num_idx <- which(spinifex::penguins_na.rm$flipper_length_mm > 185)
peng_chm_sub <- subset_cheem(peng_chm, num_idx)
lapply(peng_chm_sub, NROW)
## Notice that $global_view_df and $decode_df have fewer rows.
}
\seealso{
\code{\link[=cheem_ls]{cheem_ls()}}

Other cheem preprocessing: 
\code{\link{cheem_ls}()}
}
\concept{cheem preprocessing}
