#' Docking scores for 3212 ligands for target PPARg
#' 
#' A dataset containing docking scores for the protein regulating gene
#' peroxisome proliferator-activated receptor gamma (PPARg). 3212 ligands are
#' scored. Scores are provided for three docking methods: Surflex-dock, ICM, and
#' Vina. Scores are also provided for two consensus methods: the minimum rank
#' consensus of Surflex-dock and ICM, and the maximum z-score consensus of
#' Surflex-dock and ICM. Docking scores have been rescaled so that larger values
#' suggest active ligands.
#'   
#' @format A data frame with 3212 rows and 15 variables:
#' \describe{
#'   \item{surf_id}{unique ligand identifier}
#'   \item{surf_scores}{score from Surflex-dock}
#'   \item{surf_actives}{activity label of ligand: 1 means active, 0 means not active}
#'   \item{icm_id}{unique ligand identifier}
#'   \item{icm_scores}{score from ICM}
#'   \item{icm_actives}{activity label of ligand: 1 means active, 0 means not active}
#'   \item{vina_id}{unique ligand identifier}
#'   \item{vina_scores}{score from Vina}
#'   \item{vina_actives}{activity label of ligand: 1 means active, 0 means not active}
#'   \item{minr_id}{unique ligand identifier}
#'   \item{minr_scores}{score from the minimum rank consensus of Surflex-dock and ICM}
#'   \item{minr_actives}{activity label of ligand: 1 means active, 0 means not active}
#'   \item{maxz_id}{unique ligand identifier}
#'   \item{maxz_scores}{score from the maximum z-score consensus of Surflex-dock and ICM}
#'   \item{maxz_actives}{activity label of ligand: 1 means active, 0 means not active}
#' }
#' @source \url{http://stats.drugdesign.fr}
"pparg"