% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dst01.R
\docType{data}
\name{dst01_main}
\alias{dst01_main}
\alias{dst01_pre}
\alias{dst01_post}
\alias{dst01}
\title{DST01 Table 1 (Default) Patient Disposition Table 1.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
dst01_main(
  adam_db,
  arm_var = "ARM",
  lbl_overall = "All {Patient_label}",
  study_status_var = "EOSSTT",
  detail_vars = list(Discontinued = c("DCSREAS")),
  trt_status_var = NULL,
  ...
)

dst01_pre(adam_db, ...)

dst01_post(tlg, prune_0 = TRUE, ...)

dst01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable. Usually one of \code{ARM}, \code{ACTARM}, \code{TRT01A}, or \code{TRT01A}.}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{study_status_var}{(\code{string}) variable used to define patient status. Default is \code{EOSSTT}, however can also be a
variable name with the pattern \code{EOPxxSTT} where \code{xx} must be substituted by 2 digits referring to the analysis
period.}

\item{detail_vars}{Named (\code{list}) of grouped display of \code{study_status_var}. The names must be subset of unique levels
of \code{study_status_var}.}

\item{trt_status_var}{(\code{string}) variable of treatment status.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The DST01 Disposition Table provides an overview of patients
study completion. For patients who discontinued the study a reason is provided.
}
\details{
\itemize{
\item Default patient disposition table summarizing the reasons for patients withdrawal.
\item Numbers represent absolute numbers of patients and fraction of \code{N}.
\item Remove zero-count rows.
\item Split columns by arm.
\item Include a total column by default.
\item Sort withdrawal reasons by alphabetic order.
}
}
\section{Functions}{
\itemize{
\item \code{dst01_main()}: Main TLG function

\item \code{dst01_pre()}: Preprocessing

\item \code{dst01_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{adsl} table with the columns specified by \code{status_var} and \code{disc_reason_var}.
}
}
\examples{
run(dst01, syn_data, detail_vars = list(Ongoing = "STDONS"))

run(dst01, syn_data, detail_vars = list(Discontinued = "DCSREAS", Ongoing = "STDONS"))

run(
  dst01, syn_data,
  detail_vars = list(
    Discontinued = c("DCSREASGP", "DCSREAS"),
    Ongoing = "STDONS"
  )
)
}
\keyword{datasets}
