% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{format_date}
\alias{format_date}
\title{Formatting of date}
\usage{
format_date(date_format = "\%d\%b\%Y")
}
\arguments{
\item{date_format}{(\code{string}) the output format.}
}
\value{
a \code{function} converting a date into \code{string}.
}
\description{
Formatting of date
}
\note{
The date is extracted at the location of the measure, not at the location of the system.
}
\examples{
format_date("\%d\%b\%Y")(as.Date("2021-01-01"))
if ("NZ" \%in\% OlsonNames()) {
  format_date("\%d\%b\%Y")(as.POSIXct("2021-01-01 00:00:01", tz = "NZ"))
}
if ("US/Pacific" \%in\% OlsonNames()) {
  format_date("\%d\%b\%Y")(as.POSIXct("2021-01-01 00:00:01", tz = "US/Pacific"))
}
}
