% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdt02.R
\docType{data}
\name{pdt02_main}
\alias{pdt02_main}
\alias{pdt02_pre}
\alias{pdt02_post}
\alias{pdt02}
\title{\code{pdt02} Major Protocol Deviations Related to Epidemic/Pandemic Table.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
pdt02_main(
  adam_db,
  arm_var = "ARM",
  lbl_overall = NULL,
  dvreas_var = "DVREAS",
  dvterm_var = "DVTERM",
  ...
)

pdt02_pre(adam_db, ...)

pdt02_post(
  tlg,
  prune_0 = TRUE,
  dvreas_var = "DVREAS",
  dvterm_var = "DVTERM",
  ...
)

pdt02
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{dvreas_var}{(\code{string}) the variable defining the reason for deviation. By default \code{DVREAS}.}

\item{dvterm_var}{(\code{string}) the variable defining the protocol deviation term. By default \code{DVTERM}.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
A major protocol deviations
table with the number of subjects and the total number of Major Protocol Deviations Related
to Epidemic/Pandemic sorted alphabetically and deviations name sorted by frequencies.
}
\details{
\itemize{
\item Data should be filtered for major protocol deviations related to epidemic/pandemic.
\code{(AEPRELFL == "Y" & DVCAT == "MAJOR")}.
\item Numbers represent absolute numbers of subjects and fraction of \code{N}, or absolute numbers when specified.
\item Remove zero-count rows unless overridden with \code{prune_0 = FALSE}.
\item Split columns by arm.
\item Does not include a total column by default.
\item Sort by deviation reason alphabetically and within deviation reason by decreasing total number of patients with
the specific deviation term.
}
}
\section{Functions}{
\itemize{
\item \code{pdt02_main()}: Main TLG function

\item \code{pdt02_pre()}: Preprocessing

\item \code{pdt02_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{addv} table with the columns specified in \code{dvreas_var} and \code{dvterm_var}.
}
}
\examples{
run(pdt02, syn_data)
}
\keyword{datasets}
