% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature_generation.R
\name{temperature_generation}
\alias{temperature_generation}
\title{Generation of synthetic temperature records}
\usage{
temperature_generation(weather, years, sim_years,
  temperature_scenario = data.frame(Tmin = rep(0, 12), Tmax = rep(0,
  12)), seed = 99, check_temperature_scenario_type = TRUE,
  temperature_check_args = NULL, max_reference_year_difference = 5,
  warn_me = TRUE, remove_NA_scenarios = TRUE)
}
\arguments{
\item{weather}{daily weather, as produced with the fix_weather
function. Can also be generated by other means, but should contain the columns
c("Month","Day","Year","Tmin","Tmax").}

\item{years}{vector of length 2 indicating the start and end year of the time
interval to be used for calibrating the temperature generator.}

\item{sim_years}{vector of length 2 indicating the start and end year of the time
interval for which temperatures are to be generated.}

\item{temperature_scenario}{can be one of three options:
1) a data.frame with two columns Tmin and Tmax and n_intervals (default: 12) rows containing
temperature changes for all time intervals, or absolute temperatures for these intervals.
2) a temperature scenario object, consisting of the following elements: 'data' = a data frame with
n_intervals elements containing the absolute or relative temperature information (as in input option 1);
'scenario_year' = the year the scenario is representative of; 'reference_year' = the year the scenario
is representative of; 'scenario_type' = the scenario type ('absolute' or 'relative' - if NA, this is
assigned automatically); 'labels' = and elements attached to the input temperature_scenario as an
element names 'labels'. A subset of these elements can also be specified, but 'data' must be present.
3) a (named or unnamed) list containing multiple objects of types 1 and 2. In this case, outputs are
generated for all scenarios.}

\item{seed}{integer specifying the random seed for the weather generation.}

\item{check_temperature_scenario_type}{boolean variable specifying whether
temperature scenarios should be checked - and the scenario_type updated if necessary -
with the check_temperature_scenario function.}

\item{temperature_check_args}{list of arguments to be passed to the check_temperature_scenario function.
Check documentation of that function for details.}

\item{max_reference_year_difference}{for relative temperature scenarios, the maximum difference
between the reference years of the scenario and the weather record used for calibration (the median
of the two elements in the 'years' argument.}

\item{warn_me}{boolean variable specifying whether warnings should be shown. Defaults to TRUE.}

\item{remove_NA_scenarios}{boolean parameter indicating whether temperature scenarios that
contain NA values should be removed. Such scenarios would generate an error.}
}
\value{
list of data.frames containing the simulated weather, with columns c("YEARMODA",
"DATE","Year","Month","Day","Tmin","Tmax"). If temperature_scenario is a list, the output
list contains simulated temperature records for all scenarios.
}
\description{
Function to incorporate the temperature generation function of the
RMAWGEN weather generator into chillR. The weather generator is calibrated
using the weather data.frame (years between years[1] and years[2]), and then
generates synthetic weather for a user-defined time frame (bounded by sim_years[1]
and sim_years[2]). Monthly change vectors for minimum and maximum temperatures
can be specified to allow generation of temperature change scenarios.
}
\details{
Note that this function uses the temperature generation algorithms of the RMAWGEN
package. For more details, refer to the documentation of this package.
}
\examples{

Temp<-temperature_generation(KA_weather,years=c(1999,2001),
  sim_years = c(2001,2005),temperature_scenario = data.frame(Tmin=c(1,3,2,1,5,7,3,2,1,5,4,3),
  Tmax=c(1,2,3,2,1,3,2,1,2,3,4,5)))
  
Temp<-temperature_generation(weather=KA_weather,years=c(1999,2001),
  sim_years = c(2005,2010),
  temperature_scenario=data.frame(Tmin=c(1,3,5,8,12,15,15,15,10,8,3,1),
  Tmax=c(6,8,10,13,17,20,20,20,15,13,8,6)))

 
}
\author{
Eike Luedeling
}
\keyword{utility}
