# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title PhenoFlex
#' @description Combined model of the dynamic model for chill accumulation and the GDH model
#'
#' @inheritParams DynModel_driver
#' @param s1 numeric. Slope of transition from chill to heat accumulation
#' @param Tu numeric. GDH optimal temperature 
#' @param Tb numeric. GDH base temperature (lower threshold) 
#' @param Tc numeric. GDH upper temperature (upper threshold)
#' @param yc numeric. Critical value defining end of chill accumulation
#' @param Delta numeric. Width of Gaussian heat accumulation model
#' @param Imodel integer. Heat accumulation model: 0 for GDH and 1 for Gaussian
#' @param zc numeric. Critical value of z determining the end of heat accumulation
#' @param stopatzc boolean. If `TRUE`, the PhenoFlex is applied until the end of the temperature series. Default is to stop once the value zc has been reached.
#' @param basic_output boolean. If `TRUE`, only the bloomindex is returned as a named element of the return list.
#' @useDynLib chillR
#' @author Carsten Urbach <urbach@hiskp.uni-bonn.de>
#' @return
#' A list is returned with named element `bloomindex`, which is the index at which blooming occurs. When `basic_output=FALSE` also `x`, `y`, `z` and `xs` are
#' returned as named element of this list, which are numeric vectors of the same length as the input vector `temp` containing the hourly temperatures.
#' @examples
#' data(KA_weather)
#' hourtemps <- stack_hourly_temps(KA_weather, latitude=50.4)
#' iSeason <- genSeason(hourtemps, years=c(2009))
#' zc <- 190
#' yc <- 40
#' x <- PhenoFlex(temp=hourtemps$hourtemps$Temp[iSeason[[1]]],
#'                times=c(1: length(hourtemps$hourtemps$Temp[iSeason[[1]]])),
#'                zc=zc, stopatzc=TRUE, yc=yc, basic_output=FALSE)
#' DBreakDay <- x$bloomindex
#' ii <- c(1:DBreakDay)
#' plot(x=ii, y=x$z[ii], xlab="Hour Index", ylab="z", col="red", type="l")
#' abline(h=zc, lty=2)
#' plot(x=ii, y=x$y[ii], xlab="Hour Index", ylab="y", col="red", type="l")
#' abline(h=yc, lty=2)
#' @export
PhenoFlex <- function(temp, times, A0 = 6319.5, A1 = 5.939917e13, E0 = 3372.8, E1 = 9900.3, slope = 1.6, Tf = 4, s1 = 0.5, Tu = 25, Tb = 4, Tc = 36, yc = 40, Delta = 4, Imodel = 0L, zc = 190, stopatzc = TRUE, deg_celsius = TRUE, basic_output = TRUE) {
    .Call('_chillR_PhenoFlex', PACKAGE = 'chillR', temp, times, A0, A1, E0, E1, slope, Tf, s1, Tu, Tb, Tc, yc, Delta, Imodel, zc, stopatzc, deg_celsius, basic_output)
}

