% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_scen_information.R
\name{convert_scen_information}
\alias{convert_scen_information}
\title{Converts list of change scenarios to data.frame or vice versa}
\usage{
convert_scen_information(scenario_object, give_structure = TRUE)
}
\arguments{
\item{scenario_object}{can be either a data.frame or a list of change scenarios. 
If it is a data.frame, it  containing the relative change scenarios}

\item{give_structure}{boolean, by default set TRUE. If set TRUE, then the output is a
nested list of the structure: 1) Location 2)SSP 3)GCM 4)Timepoint.
If set FALSE, then returns flat list with names following the scheme:
Location.SSP.GCM.Timepoint.}
}
\value{
list / data.frame with relative change scenarios
}
\description{
Allows the user to convert a list of change scenarios to a single data.frame or 
 vice versa. If it converts from data.frame to list, the user can decide if the
 returned list should be flat or structured. In case of a list of change scenarios, the 
 list should have named elements. In case of composite names, the function assumes 
 that the location is the first part of the composite name, composite elements are
 seperated by dot.
}
\examples{
\dontrun{
download_cmip6_ecmwfr(scenario = 'ssp1_2_6',
                      area = c(55, 5.5, 47, 15.1),
                      user = 'write user id here',
                      key = 'write key here',
                      model = 'AWI-CM-1-1-MR',
                      frequency = 'monthly',
                      variable = c('Tmin', 'Tmax'),
                      year_start = 2015,
                      year_end = 2100)

download_baseline_cmip6_ecmwfr(
    area = c(55, 5.5, 47, 15.1),
    user = 'write user id here',
    key = 'write key here',
    model = 'AWI-CM-1-1-MR',
    frequency = 'monthly',

station <- data.frame(
      station_name = c('Zaragoza', 'Klein-Altendorf', 'Sfax',
      'Cieza', 'Meknes', 'Santomera'),
      longitude = c(-0.88,  6.99, 10.75, -1.41, -5.54, -1.05),
      latitude = c(41.65, 50.61, 34.75, 38.24, 33.88, 38.06))

extracted <- extract_cmip6_data(stations = station)

scenario_df <- gen_rel_change_scenario(extracted)

scenario_list <- convert_scen_information(scenario_df)

}

}
\author{
Lars Caspersen
}
