% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chillR-package.R
\docType{package}
\name{chillR-package}
\alias{chillR}
\alias{chillR-package}
\title{\if{html}{\figure{chillR.png}{options: width='25\%' alt='chillR logo'}}
chillR: statistical methods for phenology analysis in temperate fruit trees}
\description{
\if{latex}{\figure{chillR.png}{options: width=1in}}

\code{chillR} contains functions for processing temperature records into chilling (Chilling Hours, Utah Chill Units
and Chill Portions) and heat units (Growing Degree Hours). Regarding chilling metrics, Chill Portions are often
considered the most promising, but they are difficult to calculate. This package makes it easy.
\code{chillR} also contains procedures for conducting a Partial Least Square regression analysis relating
phenological dates (e.g. bloom dates) to either mean temperatures or mean chill and heat accumulation rates,
based on long-term weather and phenology records (Luedeling and Gassner 2012).
As of version 0.65, it also includes functions for generating weather scenarios with a weather generator,
for conducting climate change analyses for temperature-based climatic metrics and for plotting results from such
analyses. Since version 0.70, \code{chillR} contains a function for interpolating hourly temperature records.
As of version 0.72.6, the package contains functions to design elegant plots using the
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2} package.
}
\author{
\strong{Maintainer}: Eike Luedeling \email{eike@eikeluedeling.com} (\href{https://orcid.org/0000-0002-7316-3631}{ORCID})

Authors:
\itemize{
  \item Lars Caspersen \email{lcaspers@uni-bonn.de} (\href{https://orcid.org/0009-0000-3057-7327}{ORCID})
  \item Eduardo Fernandez \email{eduardo.fernandez.c@pucv.cl} (\href{https://orcid.org/0000-0002-6949-9685}{ORCID})
}

}
\keyword{internal}
