\name{chipPCR-package}
\alias{chipPCR-package}
\alias{chipPCR}
\docType{package}
\title{
Toolkit of functions to pre-process amplification data
}
\description{
The \code{chipPCR} package is a toolkit of functions to pre-process 
amplification curve data. Amplification data can be obtained from 
conventional PCR reactions or isothermal amplification reactions. The 
package contains functions to normalize and baseline amplification curves, 
a routine to detect the start of an amplification reaction, several 
smoothers for amplification data, a function to distinguish positive and 
negative amplification reactions and a function to determine the 
amplification efficiency. The smoothers are based on LOWESS, moving 
average, cubic splines, Savitzky-Golay and others. In addition the first 
approximate approximate derivative maximum (FDM) and second approximate 
derivative maximum (SDM) can be calculated by a 5-point-stencil as 
quantification points from real-time amplification curves. \code{chipPCR} 
contains data sets of experimental nucleic acid amplification systems 
including the VideoScan HCU and a capillary convective PCR (ccPCR) system. 
The amplification data were generated by helicase dependent amplification 
(HDA) or polymerase chain reaction (PCR) under various temperature 
conditions. As detection system intercalating dyes (EvaGreen, SYBR Green) 
and hydrolysis probes (TaqMan) were used.
The latest source code is available via: 
\url{https://github.com/michbur/chipPCR}
}
\details{
\tabular{ll}{
Package: \tab chipPCR\cr
Type: \tab Package\cr
Version: \tab 0.0.8-3\cr
Date: \tab 2014-09-29\cr
License: \tab GPL-3\cr
}
The function \code{\link[chipPCR]{bg.max}} can be used to remove missing 
values in amplification curve data. The function 
\code{\link[chipPCR]{amptester}} is used to test if an amplification is 
positive. \code{\link[chipPCR]{fixNA}} is used to impute missing values 
from a data column. \code{\link[chipPCR]{CPP}} can be used to normalize 
curve data, to remove background, to remove outliers and further steps. The 
package includes further functions to smooth the data by different 
functions including LOWESS, Moving Average, Friedman's SuperSmoother, Cubic 
Spline and Savitzky-Golay smoothing.
}
\author{
Stefan Roediger, Michal Burdukiewicz

Maintainer: Stefan Roediger <stefan.roediger@hs-lausitz.de>

}
\references{
A Highly Versatile Microscope Imaging Technology Platform for the Multiplex 
Real-Time Detection of Biomolecules and Autoimmune Antibodies. S. Roediger, 
P. Schierack, A. Boehm, J. Nitschke, I. Berger, U. Froemmel, C. Schmidt, M. 
Ruhland, I. Schimke, D. Roggenbuck, W. Lehmann and C. Schroeder. 
\emph{Advances in Biochemical Bioengineering/Biotechnology}. 133:33--74, 
2013. \url{http://www.ncbi.nlm.nih.gov/pubmed/22437246}

Nucleic acid detection based on the use of microbeads: a review. S. 
Roediger, C. Liebsch, C. Schmidt, W. Lehmann, U. Resch-Genger, U. Schedler, 
P. Schierack. \emph{Microchim Acta} 2014:1--18. DOI: 
10.1007/s00604-014-1243-4

Roediger S, Boehm A, Schimke I. Surface Melting Curve Analysis with R. 
\emph{The R Journal} 2013;5:37--53.
}
\keyword{ chipPCR }
\seealso{
\link[qpcR]{qpcR.news}.
}
\examples{
# Example: A simple function to test for a background range.
# Data were taken form the chipPCR C17 data set.
data(C17)
plot(C17[, 2], C17[,  3], xlab = "time [min]", ylab = "Fluorescence", 
      pch = 20)
res <- bg.max(C17[, 2], C17[, 3], bg.corr = 1.4, bg.start = 3)
abline(v = c(slot(res, "bg.start"), slot(res, "bg.stop")), col = c(1,2))
abline(h = slot(res, "fluo"), col = "blue")
}
