% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-subset.R
\name{chk_subset}
\alias{chk_subset}
\alias{vld_subset}
\title{Check Subset}
\usage{
chk_subset(x, values, x_name = NULL)

vld_subset(x, values)
}
\arguments{
\item{x}{The object to check.}

\item{values}{A vector of the permitted values.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if all values in values using

\code{all(x \%in\% values)}
}
\section{Functions}{
\itemize{
\item \code{vld_subset}: Validate Subset
}}

\examples{
# chk_subset
chk_subset(1, 1:10)
try(chk_subset(11, 1:10))
# vld_subset
vld_subset(numeric(0), 1:10)
vld_subset(1, 1:10)
vld_subset(11, 1:10)
}
\seealso{
Other chk_set: 
\code{\link{chk_join}()},
\code{\link{chk_setequal}()},
\code{\link{chk_superset}()}
}
\concept{chk_set}
