% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-character-or-factor.R
\name{chk_character_or_factor}
\alias{chk_character_or_factor}
\alias{vld_character_or_factor}
\title{Check Character or Factor}
\usage{
chk_character_or_factor(x, x_name = NULL)

vld_character_or_factor(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if character or factor using

\code{is.character(x) || is.factor(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_character_or_factor}: Validate Character or Factor
}}

\examples{
# chk_character_or_factor
chk_character_or_factor("1")
chk_character_or_factor(factor("1"))
try(chk_character(1))
# vld_character_or_factor
vld_character_or_factor("1")
vld_character_or_factor(matrix("a"))
vld_character_or_factor(character(0))
vld_character_or_factor(NA_character_)
vld_character_or_factor(1)
vld_character_or_factor(TRUE)
vld_character_or_factor(factor("text"))
}
\seealso{
Other chk_typeof: 
\code{\link{chk_character}()},
\code{\link{chk_count}()},
\code{\link{chk_double}()},
\code{\link{chk_environment}()},
\code{\link{chk_factor}()},
\code{\link{chk_integer}()},
\code{\link{chk_list}()},
\code{\link{chk_logical}()}
}
\concept{chk_typeof}
