% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-not-missing.R
\name{chk_not_missing}
\alias{chk_not_missing}
\alias{vld_not_missing}
\title{Check Not Missing Argument}
\usage{
chk_not_missing(x, x_name = "`x`")

vld_not_missing(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks argument not missing using

\code{!missing(x)}
}
\details{
Currently only checks if value is available
(as opposed to whether it was specified).
}
\section{Functions}{
\itemize{
\item \code{vld_not_missing()}: Validate Not Missing Argument

}}
\examples{
# chk_not_missing
fun <- function(x) {
  chk_not_missing(x)
}
fun(1)
try(fun())
# vld_not_missing
fun <- function(x) {
  vld_not_missing(x)
}
fun()
fun(1)
}
\seealso{
Other chk_misc: 
\code{\link{chk_length}()},
\code{\link{chk_match}()},
\code{\link{chk_missing}()},
\code{\link{chk_named}()},
\code{\link{chk_not_any_na}()},
\code{\link{chk_not_empty}()},
\code{\link{chk_sorted}()},
\code{\link{chk_unique}()},
\code{\link{chk_valid_name}()}
}
\concept{chk_misc}
