% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_data.R
\docType{data}
\name{woods2003}
\alias{woods2003}
\title{Chlorpromazine equivalent key from Woods 2003 data}
\format{A named list of 3 named lists (1 for each route) and each sub-list
contains the conversion factors for each antipsychotic. The 3 top-level lists
are named `oral`, `sai`, and `lai` (route), and the lists they contain have
names corresponding to the antipsychotic, e.g. `olanzapine`.}
\source{
Scott Woods (2003). Chlorpromazine Equivalent Doses for the Newer
Atypical Antipsychotics. Journal of Clinical Psychiatry. 64(6). 663-667.
<https://doi.org/10.4088/JCP.v64n0607>
}
\usage{
woods2003
}
\description{
A list of antipsychotics and their chlorpromazine equivalent doses, generated
from the following file included with the package:
system.file("extdata", "woods2003.csv", package="chlorpromazineR").
}
\keyword{datasets}
