% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addVoronoi.R
\name{addVoronoi}
\alias{addVoronoi}
\title{Add Voronoi cells.}
\usage{
addVoronoi(pump.select = NULL, vestry = FALSE, color = "black",
  line.type = "solid", ...)
}
\arguments{
\item{pump.select}{Numeric. Default is NULL; all pumps are used. Otherwise, selection by a vector of numeric IDs: 1 to 13 for \code{pumps}; 1 to 14 for \code{pumps.vestry}. Exclusion (negative selection) is possible (e.g., -6).}

\item{vestry}{Logical. FALSE for original 13 pumps. TRUE for 14 pumps in Vestry Report.}

\item{color}{Character. Color of cell edges.}

\item{line.type}{Character. Type of line for cell edges.}

\item{...}{Additional plotting parameters.}
}
\description{
Uses deldir::deldir().
}
\examples{
snowMap(add.landmarks = FALSE)
addVoronoi()
}
\seealso{
\code{\link{snowMap}},
\code{\link{addIndexCase}},
\code{\link{addKernelDensity}},
\code{\link{addLandmarks}},
\code{\link{addPlaguePit}},
\code{\link{addSnow}},
\code{\link{addWhitehead}}
}
