% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addKernelDensity.R
\name{addKernelDensity}
\alias{addKernelDensity}
\title{Add 2D kernel density contours.}
\usage{
addKernelDensity(pump.subset = "pooled", pump.select = NULL,
  neighborhood.type = "walking", obs.unit = "unstacked", bandwidth = 0.5,
  color = "black", line.type = "solid", multi.core = FALSE, ...)
}
\arguments{
\item{pump.subset}{Character or Numeric: "pooled", "individual", or numeric vector. "pooled" treats all observations as a single set. "individual" is a shortcut for all individual pump neighborhoods. Use of vector of numeric pump IDs to select (subset) from the neighborhoods defined by "pump.select". Negative selection possible. NULL selects all pumps in "pump.select".}

\item{pump.select}{Numeric. Vector of numeric pump IDs to define pump neighborhoods (i.e., the "population"). Negative selection possible. NULL selects all pumps.}

\item{neighborhood.type}{Character. "voronoi" or "walking"}

\item{obs.unit}{Character. Unit of observation. "unstacked" uses \code{fatalities.unstacked}. "address" uses \code{fatalities.address}. "fatality" uses \code{fatalities}.}

\item{bandwidth}{Numeric. Bandwidth for kernel density estimation.}

\item{color}{Character. Color of contour lines.}

\item{line.type}{Character. Line type for contour lines.}

\item{multi.core}{Logical or Numeric. TRUE uses parallel::detectCores(). FALSE uses one, single core. You can also specify the number logical cores. On Window, only "multi.core = FALSE" is available.}

\item{...}{Additional plotting parameters.}
}
\value{
Add contours to a graphics plot.
}
\description{
Add 2D kernel density contours based on selected sets of observations.
}
\note{
This function uses KernSmooth::bkde2D().
}
\examples{
# snowMap()
# addKernelDensity()

# snowMap()
# addKernelDensity("individual")

# snowMap()
# addKernelDensity(c(6, 8))

# snowMap()
# addKernelDensity(pump.select = c(6, 8))
}
\seealso{
\code{\link{snowMap}},
\code{\link{addIndexCase}},
\code{\link{addLandmarks}},
\code{\link{addPlaguePit}},
\code{\link{addSnow}},
\code{\link{addVoronoi}},
\code{\link{addWhitehead}}
}
