% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attach_metadata.R
\name{attach_metadata}
\alias{attach_metadata}
\title{Attach experimental metadata}
\usage{
attach_metadata(peak_table, metadata, column)
}
\arguments{
\item{peak_table}{A `peak_table` object.}

\item{metadata}{A `data.frame` containing the sample meta-data.}

\item{column}{The name of the column containing the sample names.}
}
\value{
A \code{peak_table} object with attached metadata in the \code{
$sample_meta} slot.
}
\description{
Attaches experimental metadata to `peak_table` object. One of the columns in
the supplied metadata must match exactly the row names of the peak table.
}
\examples{
data(pk_tab)
path <- system.file("extdata", "Sa_metadata.csv", package = "chromatographR")
meta <- read.csv(path)
pk_tab <- attach_metadata(peak_table = pk_tab, metadata = meta, column="vial")
}
\seealso{
\code{\link{get_peaktable}} \code{\link{normalize_data}}
}
\author{
Ethan Bass
}
