% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browser.R
\name{Browser}
\alias{Browser}
\title{Browser base class}
\description{
Browser base class

Browser base class
}
\details{
Base class for browsers like Chrome, Chromium, etc. Defines the interface
used by various browser implementations. It can represent a local browser
process or one running remotely.

The \code{initialize()} method of an implementation should set private$host
and private$port. If the process is local, the \code{initialize()} method
should also set private$process.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-is_local}{\code{Browser$is_local()}}
\item \href{#method-get_process}{\code{Browser$get_process()}}
\item \href{#method-get_host}{\code{Browser$get_host()}}
\item \href{#method-get_port}{\code{Browser$get_port()}}
\item \href{#method-close}{\code{Browser$close()}}
\item \href{#method-clone}{\code{Browser$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_local"></a>}}
\if{latex}{\out{\hypertarget{method-is_local}{}}}
\subsection{Method \code{is_local()}}{
Is local browser?
Returns TRUE if the browser is running locally, FALSE if it's remote.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Browser$is_local()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_process"></a>}}
\if{latex}{\out{\hypertarget{method-get_process}{}}}
\subsection{Method \code{get_process()}}{
Browser process
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Browser$get_process()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_host"></a>}}
\if{latex}{\out{\hypertarget{method-get_host}{}}}
\subsection{Method \code{get_host()}}{
Browser Host
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Browser$get_host()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_port"></a>}}
\if{latex}{\out{\hypertarget{method-get_port}{}}}
\subsection{Method \code{get_port()}}{
Browser port
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Browser$get_port()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-close"></a>}}
\if{latex}{\out{\hypertarget{method-close}{}}}
\subsection{Method \code{close()}}{
Close the browser
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Browser$close()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Browser$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
