% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chromote_session.R
\name{ChromoteSession}
\alias{ChromoteSession}
\title{ChromoteSession class}
\description{
ChromoteSession class

ChromoteSession class
}
\examples{

## ------------------------------------------------
## Method `ChromoteSession$new`
## ------------------------------------------------

\dontrun{# Create a new `ChromoteSession` object.
b <- ChromoteSession$new()

# Create a ChromoteSession with a specific height,width
b <- ChromoteSession$new(height = 1080, width = 1920)

# Navigate to page
b$Page$navigate("http://www.r-project.org/")

# View current chromote session
if (interactive()) b$view()}

## ------------------------------------------------
## Method `ChromoteSession$view`
## ------------------------------------------------

\dontrun{# Create a new `ChromoteSession` object.
b <- ChromoteSession$new()

# Navigate to page
b$Page$navigate("http://www.r-project.org/")

# View current chromote session
if (interactive()) b$view()}

## ------------------------------------------------
## Method `ChromoteSession$close`
## ------------------------------------------------

\dontrun{# Create a new `ChromoteSession` object.
b <- ChromoteSession$new()

# Navigate to page
b$Page$navigate("http://www.r-project.org/")

# Close current chromote session
b$close()}

## ------------------------------------------------
## Method `ChromoteSession$screenshot`
## ------------------------------------------------

\dontrun{# Create a new `ChromoteSession` object.
b <- ChromoteSession$new()

# Navigate to page
b$Page$navigate("http://www.r-project.org/")

# Take screenshot
tmppngfile <- tempfile(fileext = ".png")
is_interactive <- interactive() # Display screenshot if interactive
b$screenshot(tmppngfile, show = is_interactive)

# Show screenshot file info
unlist(file.info(tmppngfile))


# Take screenshot using a selector
sidebar_file <- tempfile(fileext = ".png")
b$screenshot(sidebar_file, selector = ".sidebar", show = is_interactive)

# ----------------------------
# Take screenshots in parallel

urls <- c(
  "https://www.r-project.org/",
  "https://github.com/",
  "https://news.ycombinator.com/"
)
# Helper method that:
# 1. Navigates to the given URL
# 2. Waits for the page loaded event to fire
# 3. Takes a screenshot
# 4. Prints a message
# 5. Close the ChromoteSession
screenshot_p <- function(url, filename = NULL) {
  if (is.null(filename)) {
    filename <- gsub("^.*://", "", url)
    filename <- gsub("/", "_", filename)
    filename <- gsub("\\\\.", "_", filename)
    filename <- sub("_$", "", filename)
    filename <- paste0(filename, ".png")
  }

  b2 <- b$new_session()
  b2$Page$navigate(url, wait_ = FALSE)
  b2$Page$loadEventFired(wait_ = FALSE)$
    then(function(value) {
      b2$screenshot(filename, wait_ = FALSE)
    })$
    then(function(value) {
      message(filename)
    })$
    finally(function() {
      b2$close()
    })
}

# Take multiple screenshots simultaneously
ps <- lapply(urls, screenshot_p)
pa <- promises::promise_all(.list = ps)$then(function(value) {
  message("Done!")
})

# Block the console until the screenshots finish (optional)
b$wait_for(pa)
#> www_r-project_org.png
#> github_com.png
#> news_ycombinator_com.png
#> Done!}

## ------------------------------------------------
## Method `ChromoteSession$screenshot_pdf`
## ------------------------------------------------

\dontrun{# Create a new `ChromoteSession` object.
b <- ChromoteSession$new()

# Navigate to page
b$Page$navigate("http://www.r-project.org/")

# Take screenshot
tmppdffile <- tempfile(fileext = ".pdf")
b$screenshot_pdf(tmppdffile)

# Show PDF file info
unlist(file.info(tmppdffile))}

## ------------------------------------------------
## Method `ChromoteSession$new_session`
## ------------------------------------------------

\dontrun{b1 <- ChromoteSession$new()
b1$Page$navigate("http://www.google.com")
b2 <- b1$new_session()
b2$Page$navigate("http://www.r-project.org/")
b1$Runtime$evaluate("window.location", returnByValue = TRUE)$result$value$href
#> [1] "https://www.google.com/"
b2$Runtime$evaluate("window.location", returnByValue = TRUE)$result$value$href
#> [1] "https://www.r-project.org/"}

## ------------------------------------------------
## Method `ChromoteSession$get_session_id`
## ------------------------------------------------

\dontrun{b <- ChromoteSession$new()
b$get_session_id()
#> [1] "05764F1D439F4292497A21C6526575DA"}

## ------------------------------------------------
## Method `ChromoteSession$wait_for`
## ------------------------------------------------

\dontrun{b <- ChromoteSession$new()

# Async with promise
p <- b$Browser$getVersion(wait_ = FALSE)
p$then(str)

# Async with callback
b$Browser$getVersion(wait_ = FALSE, callback_ = str)}

## ------------------------------------------------
## Method `ChromoteSession$debug_log`
## ------------------------------------------------

\dontrun{b <- ChromoteSession$new()
b$parent$debug_messages(TRUE)
b$Page$navigate("https://www.r-project.org/")
#> SEND {"method":"Page.navigate","params":{"url":"https://www.r-project.org/"}| __truncated__}
# Turn off debug messages
b$parent$debug_messages(FALSE)}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{parent}}{\code{\link{Chromote}} object}

\item{\code{default_timeout}}{Default timeout in seconds for \pkg{chromote} to
wait for a Chrome DevTools Protocol response.}

\item{\code{protocol}}{Dynamic protocol implementation. For expert use only!}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ChromoteSession-new}{\code{ChromoteSession$new()}}
\item \href{#method-ChromoteSession-view}{\code{ChromoteSession$view()}}
\item \href{#method-ChromoteSession-close}{\code{ChromoteSession$close()}}
\item \href{#method-ChromoteSession-screenshot}{\code{ChromoteSession$screenshot()}}
\item \href{#method-ChromoteSession-screenshot_pdf}{\code{ChromoteSession$screenshot_pdf()}}
\item \href{#method-ChromoteSession-new_session}{\code{ChromoteSession$new_session()}}
\item \href{#method-ChromoteSession-get_session_id}{\code{ChromoteSession$get_session_id()}}
\item \href{#method-ChromoteSession-wait_for}{\code{ChromoteSession$wait_for()}}
\item \href{#method-ChromoteSession-debug_log}{\code{ChromoteSession$debug_log()}}
\item \href{#method-ChromoteSession-get_child_loop}{\code{ChromoteSession$get_child_loop()}}
\item \href{#method-ChromoteSession-send_command}{\code{ChromoteSession$send_command()}}
\item \href{#method-ChromoteSession-get_auto_events}{\code{ChromoteSession$get_auto_events()}}
\item \href{#method-ChromoteSession-invoke_event_callbacks}{\code{ChromoteSession$invoke_event_callbacks()}}
\item \href{#method-ChromoteSession-mark_closed}{\code{ChromoteSession$mark_closed()}}
\item \href{#method-ChromoteSession-is_active}{\code{ChromoteSession$is_active()}}
\item \href{#method-ChromoteSession-init_promise}{\code{ChromoteSession$init_promise()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-new"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{ChromoteSession} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$new(
  parent = default_chromote_object(),
  width = 992,
  height = 1323,
  targetId = NULL,
  wait_ = TRUE,
  auto_events = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parent}}{\code{\link{Chromote}} object to use; defaults to
\code{\link[=default_chromote_object]{default_chromote_object()}}}

\item{\code{width}}{Width, in pixels, of the \code{Target} to create if \code{targetId} is
\code{NULL}}

\item{\code{height}}{Height, in pixels, of the \code{Target} to create if \code{targetId} is
\code{NULL}}

\item{\code{targetId}}{\href{https://chromedevtools.github.io/devtools-protocol/tot/Target/}{Target}
ID of an existing target to attach to. When a \code{targetId} is provided, the
\code{width} and \code{height} arguments are ignored. If NULL (the default) a new
target is created and attached to, and the \code{width} and \code{height}
arguments determine its viewport size.}

\item{\code{wait_}}{If \code{FALSE}, return a \code{\link[promises:promise]{promises::promise()}} of a new
\code{ChromoteSession} object. Otherwise, block during initialization, and
return a \code{ChromoteSession} object directly.}

\item{\code{auto_events}}{If \code{NULL} (the default), use the \code{auto_events} setting
from the parent \code{Chromote} object. If \code{TRUE}, enable automatic
event enabling/disabling; if \code{FALSE}, disable automatic event
enabling/disabling.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ChromoteSession} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{# Create a new `ChromoteSession` object.
b <- ChromoteSession$new()

# Create a ChromoteSession with a specific height,width
b <- ChromoteSession$new(height = 1080, width = 1920)

# Navigate to page
b$Page$navigate("http://www.r-project.org/")

# View current chromote session
if (interactive()) b$view()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-view"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-view}{}}}
\subsection{Method \code{view()}}{
Display the current session in the \code{\link{Chromote}} browser.

If a \code{\link{Chrome}} browser is being used, this method will open a new tab
using your \code{\link{Chrome}} browser. When not using a \code{\link{Chrome}} browser, set
\code{options(browser=)} to change the default behavior of \code{\link[=browseURL]{browseURL()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$view()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{# Create a new `ChromoteSession` object.
b <- ChromoteSession$new()

# Navigate to page
b$Page$navigate("http://www.r-project.org/")

# View current chromote session
if (interactive()) b$view()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-close"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-close}{}}}
\subsection{Method \code{close()}}{
Close the Chromote session.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$close(wait_ = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{wait_}}{If \code{FALSE}, return a \code{\link[promises:promise]{promises::promise()}} that will resolve
when the \code{ChromoteSession} is closed. Otherwise, block until the
\code{ChromoteSession} has closed.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{# Create a new `ChromoteSession` object.
b <- ChromoteSession$new()

# Navigate to page
b$Page$navigate("http://www.r-project.org/")

# Close current chromote session
b$close()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-screenshot"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-screenshot}{}}}
\subsection{Method \code{screenshot()}}{
Take a PNG screenshot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$screenshot(
  filename = "screenshot.png",
  selector = "html",
  cliprect = NULL,
  region = c("content", "padding", "border", "margin"),
  expand = NULL,
  scale = 1,
  show = FALSE,
  delay = 0.5,
  wait_ = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{File path of where to save the screenshot.}

\item{\code{selector}}{CSS selector to use for the screenshot.}

\item{\code{cliprect}}{A list containing \code{x}, \code{y}, \code{width}, and \code{height}. See
\href{https://chromedevtools.github.io/devtools-protocol/tot/Page/#type-Viewport}{\code{Page.Viewport}}
for more information. If provided, \code{selector} and \code{expand} will be
ignored. To provide a scale, use the \code{scale} parameter.}

\item{\code{region}}{CSS region to use for the screenshot.}

\item{\code{expand}}{Extra pixels to expand the screenshot. May be a single
value or a numeric vector of top, right, bottom, left values.}

\item{\code{scale}}{Page scale factor}

\item{\code{show}}{If \code{TRUE}, the screenshot will be displayed in the viewer.}

\item{\code{delay}}{The number of seconds to wait before taking the screenshot
after resizing the page. For complicated pages, this may need to be
increased.}

\item{\code{wait_}}{If \code{FALSE}, return a \code{\link[promises:promise]{promises::promise()}} that will resolve
when the \code{ChromoteSession} has saved the screenshot. Otherwise, block
until the \code{ChromoteSession} has saved the screenshot.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{# Create a new `ChromoteSession` object.
b <- ChromoteSession$new()

# Navigate to page
b$Page$navigate("http://www.r-project.org/")

# Take screenshot
tmppngfile <- tempfile(fileext = ".png")
is_interactive <- interactive() # Display screenshot if interactive
b$screenshot(tmppngfile, show = is_interactive)

# Show screenshot file info
unlist(file.info(tmppngfile))


# Take screenshot using a selector
sidebar_file <- tempfile(fileext = ".png")
b$screenshot(sidebar_file, selector = ".sidebar", show = is_interactive)

# ----------------------------
# Take screenshots in parallel

urls <- c(
  "https://www.r-project.org/",
  "https://github.com/",
  "https://news.ycombinator.com/"
)
# Helper method that:
# 1. Navigates to the given URL
# 2. Waits for the page loaded event to fire
# 3. Takes a screenshot
# 4. Prints a message
# 5. Close the ChromoteSession
screenshot_p <- function(url, filename = NULL) {
  if (is.null(filename)) {
    filename <- gsub("^.*://", "", url)
    filename <- gsub("/", "_", filename)
    filename <- gsub("\\\\.", "_", filename)
    filename <- sub("_$", "", filename)
    filename <- paste0(filename, ".png")
  }

  b2 <- b$new_session()
  b2$Page$navigate(url, wait_ = FALSE)
  b2$Page$loadEventFired(wait_ = FALSE)$
    then(function(value) {
      b2$screenshot(filename, wait_ = FALSE)
    })$
    then(function(value) {
      message(filename)
    })$
    finally(function() {
      b2$close()
    })
}

# Take multiple screenshots simultaneously
ps <- lapply(urls, screenshot_p)
pa <- promises::promise_all(.list = ps)$then(function(value) {
  message("Done!")
})

# Block the console until the screenshots finish (optional)
b$wait_for(pa)
#> www_r-project_org.png
#> github_com.png
#> news_ycombinator_com.png
#> Done!}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-screenshot_pdf"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-screenshot_pdf}{}}}
\subsection{Method \code{screenshot_pdf()}}{
Take a PDF screenshot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$screenshot_pdf(
  filename = "screenshot.pdf",
  pagesize = "letter",
  margins = 0.5,
  units = c("in", "cm"),
  landscape = FALSE,
  display_header_footer = FALSE,
  print_background = FALSE,
  scale = 1,
  wait_ = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{File path of where to save the screenshot.}

\item{\code{pagesize}}{A single character value in the set \code{"letter"},
\code{"legal"}, \code{"tabloid"}, \code{"ledger"} and \code{"a0"} through \code{"a1"}. Or a
numeric vector \code{c(width, height)} specifying the page size.}

\item{\code{margins}}{A numeric vector \code{c(top, right, bottom, left)} specifying
the page margins.}

\item{\code{units}}{Page and margin size units. Either \code{"in"} or \code{"cm"} for
inches and centimeters respectively.}

\item{\code{landscape}}{Paper orientation.}

\item{\code{display_header_footer}}{Display header and footer.}

\item{\code{print_background}}{Print background graphics.}

\item{\code{scale}}{Page scale factor.}

\item{\code{wait_}}{If \code{FALSE}, return a \code{\link[promises:promise]{promises::promise()}} that will resolve
when the \code{ChromoteSession} has saved the screenshot. Otherwise, block
until the \code{ChromoteSession} has saved the screnshot.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{# Create a new `ChromoteSession` object.
b <- ChromoteSession$new()

# Navigate to page
b$Page$navigate("http://www.r-project.org/")

# Take screenshot
tmppdffile <- tempfile(fileext = ".pdf")
b$screenshot_pdf(tmppdffile)

# Show PDF file info
unlist(file.info(tmppdffile))}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-new_session"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-new_session}{}}}
\subsection{Method \code{new_session()}}{
Create a new tab / window
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$new_session(
  width = 992,
  height = 1323,
  targetId = NULL,
  wait_ = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width, height}}{Width and height of the new window.}

\item{\code{targetId}}{\href{https://chromedevtools.github.io/devtools-protocol/tot/Target/}{Target}
ID of an existing target to attach to. When a \code{targetId} is provided, the
\code{width} and \code{height} arguments are ignored. If NULL (the default) a new
target is created and attached to, and the \code{width} and \code{height}
arguments determine its viewport size.}

\item{\code{wait_}}{If \code{FALSE}, return a \code{\link[promises:promise]{promises::promise()}} that will resolve
when the \code{ChromoteSession} has created a new session. Otherwise, block
until the \code{ChromoteSession} has created a new session.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{b1 <- ChromoteSession$new()
b1$Page$navigate("http://www.google.com")
b2 <- b1$new_session()
b2$Page$navigate("http://www.r-project.org/")
b1$Runtime$evaluate("window.location", returnByValue = TRUE)$result$value$href
#> [1] "https://www.google.com/"
b2$Runtime$evaluate("window.location", returnByValue = TRUE)$result$value$href
#> [1] "https://www.r-project.org/"}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-get_session_id"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-get_session_id}{}}}
\subsection{Method \code{get_session_id()}}{
Retrieve the session id
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$get_session_id()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{b <- ChromoteSession$new()
b$get_session_id()
#> [1] "05764F1D439F4292497A21C6526575DA"}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-wait_for"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-wait_for}{}}}
\subsection{Method \code{wait_for()}}{
Wait for a Chromote Session to finish. This method will block the R
session until the provided promise resolves. The loop from
\verb{$get_child_loop()} will only advance just far enough for the promise to
resolve.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$wait_for(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{A promise to resolve.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{b <- ChromoteSession$new()

# Async with promise
p <- b$Browser$getVersion(wait_ = FALSE)
p$then(str)

# Async with callback
b$Browser$getVersion(wait_ = FALSE, callback_ = str)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-debug_log"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-debug_log}{}}}
\subsection{Method \code{debug_log()}}{
Send a debug log message to the parent \link{Chromote} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$debug_log(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments pasted together with \code{paste0(..., collapse = "")}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{b <- ChromoteSession$new()
b$parent$debug_messages(TRUE)
b$Page$navigate("https://www.r-project.org/")
#> SEND {"method":"Page.navigate","params":{"url":"https://www.r-project.org/"}| __truncated__}
# Turn off debug messages
b$parent$debug_messages(FALSE)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-get_child_loop"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-get_child_loop}{}}}
\subsection{Method \code{get_child_loop()}}{
\pkg{later} loop.

For expert async usage only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$get_child_loop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-send_command"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-send_command}{}}}
\subsection{Method \code{send_command()}}{
Send command through Chrome DevTools Protocol.

For expert use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$send_command(
  msg,
  callback = NULL,
  error = NULL,
  timeout = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{msg}}{A JSON-serializable list containing \code{method}, and \code{params}.}

\item{\code{callback}}{Method to run when the command finishes successfully.}

\item{\code{error}}{Method to run if an error occurs.}

\item{\code{timeout}}{Number of milliseconds for Chrome DevTools Protocol
execute a method.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-get_auto_events"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-get_auto_events}{}}}
\subsection{Method \code{get_auto_events()}}{
Resolved \code{auto_events} value.

For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$get_auto_events()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-invoke_event_callbacks"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-invoke_event_callbacks}{}}}
\subsection{Method \code{invoke_event_callbacks()}}{
Immediately call all event callback methods.

For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$invoke_event_callbacks(event, params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{event}}{A single event string}

\item{\code{params}}{A list of parameters to pass to the event callback methods.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-mark_closed"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-mark_closed}{}}}
\subsection{Method \code{mark_closed()}}{
Disable callbacks for a given session.

For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$mark_closed()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-is_active"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-is_active}{}}}
\subsection{Method \code{is_active()}}{
Retrieve active status
Once initialized, the value returned is \code{TRUE}. If \verb{$close()} has been
called, this value will be \code{FALSE}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$is_active()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ChromoteSession-init_promise"></a>}}
\if{latex}{\out{\hypertarget{method-ChromoteSession-init_promise}{}}}
\subsection{Method \code{init_promise()}}{
Initial promise

For internal use only.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ChromoteSession$init_promise()}\if{html}{\out{</div>}}
}

}
}
