% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxplots.R
\name{make_boxplot}
\alias{make_boxplot}
\title{Create a box plot from a data frame through ggplotly}
\usage{
make_boxplot(
  dt,
  value,
  groups = NULL,
  jitter = FALSE,
  ggtheme = "minimal",
  x_axis_label = NULL,
  y_axis_label = NULL,
  plot_palette = NULL,
  plot_palette_generator = "plasma"
)
}
\arguments{
\item{dt}{data.frame containing the data to plot.}

\item{value}{Name of the column to use as values on the y axis of the plot.}

\item{groups}{Name of the column containing the different groups.}

\item{jitter}{Whether to add the actual values of each observation over the box plots. Only done when dt has 1000 rows or less.}

\item{ggtheme}{ggplot2 theme function to apply. Default is ggplot2::theme_minimal.}

\item{x_axis_label}{Label for the x axis.}

\item{y_axis_label}{Label for the y axis.}

\item{plot_palette}{Character vector of hex codes specifying the colors to use on the plot.}

\item{plot_palette_generator}{Palette from the viridis package used in case plot_palette is unspecified or insufficient for the number of colors required}
}
\value{
A plotly-ized version of a ggplot box plot.
}
\description{
Create a box plot from a data frame through ggplotly
}
\examples{
make_boxplot(dt = ggplot2::mpg, value = 'hwy', groups = 'drv', jitter = TRUE)

}
