% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RasterArray-base.R
\docType{methods}
\name{apply}
\alias{apply}
\alias{apply,RasterArray-method}
\title{Apply-type iterator for RasterArrays}
\usage{
apply(X, MARGIN, FUN, ...)

\S4method{apply}{RasterArray}(X, MARGIN, FUN, ...)
}
\arguments{
\item{X}{an array, including matrices and RasterArrays.}

\item{MARGIN}{a vector giving the subscripts which the function will be applied over. E.g., for a matrix 1 indicates rows, 2 indicates columns, \code{c(1, 2)} indicates rows and columns. Where \code{X} has named dimnames, it can be a character vector selecting dimension names. For \code{RasterArrays} only single dimension margins are implemented.}

\item{FUN}{the function to be applied: see ‘Details’ of \code{\link[base]{apply}}.}

\item{...}{optional arguments passed to \code{FUN}.}
}
\value{
Depending on the on the output of \code{FUN}, a \code{list}, a \code{vector} or \code{RasterArray} object.
}
\description{
The function implements the \code{\link[base]{apply}}-type iterators for the RasterArray class. Output values are constrained to RasterArrays, whenever possible. 
Not yet implemented for multidimensional MARGINs.
}
\examples{
# double of itself
data(dems)
a<- cbind(dems, dems)
same <- apply(a, 1, sum)
}
