% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_nifti.R
\name{write_subcort_nifti}
\alias{write_subcort_nifti}
\title{Write subcortical data to NIFTI files}
\usage{
write_subcort_nifti(
  subcortVol,
  subcortLabs,
  subcortMask,
  trans_mat = NULL,
  trans_units = NULL,
  col_names = NULL,
  label_table = NULL,
  subcortVol_fname,
  subcortLabs_fname,
  ROIsubcortVol_fname = NULL,
  fill = 0
)
}
\arguments{
\item{subcortVol}{A vectorized data matrix: V voxels by T measurements}

\item{subcortLabs}{Numeric (0 and 3-21) or factor vector corresponding to
subcortical structure labels. See \code{\link{substructure_table}}.}

\item{subcortMask}{Logical volumetric mask. Values of 0 represent out-of-mask
voxels (not subcortical), and values of 1 represent in-mask voxels
(subcortical),}

\item{trans_mat}{The TransformationMatrixIJKtoXYZ, or equivalently the desired
sform matrix (srow_x, srow_y and srow_z) to write. If \code{NULL}, do not
write it (all zeroes).}

\item{trans_units}{The units of \code{trans_mat}. Currently not used.}

\item{col_names}{(Optional) Column names.}

\item{label_table}{(Optional) \code{data.frame} of labels and their colors.}

\item{subcortVol_fname, subcortLabs_fname, ROIsubcortVol_fname}{File path to
a NIFTI to save the corresponding data. \code{ROIsubcortVol_fname} is
optional but the rest is required.}

\item{fill}{Values to use for out-of-mask voxels. Default: \code{0}.}
}
\value{
Named character vector with the \code{"subcortVol"},
\code{"subcortLabs"}, and \code{"ROIsubcortVol"} file names (if written)
}
\description{
Write subcortical data to NIFTI files representing the data values,
subcortical structure labels, and volumetric mask. The input formats of
\code{subcortVol}, \code{subcortLabs}, and \code{subcortMask}
correspond to the data structures of \code{xifti$data$subcort},
\code{xifti$meta$subcort$labels} , and \code{xifti$meta$subcort$mask}
respectively. \code{subcortVol} and \code{subcortLabs} should be vectorized,
so if they are volumes consider using \code{RNifti::writeNIfTI}.
}
\details{
All file path arguments are required except \code{ROIsubcortVol_fname}. If
not provided, the volumetric mask will not be written. (It's redundant with
the 0 values in \code{subcortLabs_fname} because valid labels have positive
indexes.)

Note that for label data (i.e. if \code{label_table} is provided) only one
label table can be saved.
}
\section{Connectome Workbench}{

This function interfaces with the \code{"-volume-label-import"} Workbench
Command.
}

\seealso{
Other functions for writing CIFTI or GIFTI data: 
\code{\link{separate_cifti}()},
\code{\link{write_cifti}()},
\code{\link{write_metric_gifti}()},
\code{\link{write_surf_gifti}()}
}
\concept{writing}
