% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.r
\docType{package}
\name{cimir}
\alias{cimir}
\alias{cimir-package}
\title{cimir: Interface to CIMIS}
\description{
This package provides an R interface to the
\href{https://cimis.water.ca.gov}{California Irrigation Management Information System}
(CIMIS) \href{https://et.water.ca.gov}{Web API}. In order to use
this package, you will need to
\href{https://cimis.water.ca.gov/Auth/Register.aspx}{create a CIMIS account}
and request a web services AppKey.
}
\section{Package options}{


cimir uses the following \code{\link[=options]{options()}} to configure behavior:

\itemize{
\item \code{cimir.appkey}: The CIMIS AppKey to use for queries.
\item \code{cimir.timeout}: The maximum time to wait for a response
from the CIMIS Web API.
}
Alternatively, the CIMIS App Key can be saved to an environment
variable \code{CIMIS_APPKEY}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/mkoohafkan/cimir}
  \item Report bugs at \url{https://github.com/mkoohafkan/cimir/issues}
}

}
\author{
\strong{Maintainer}: Michael Koohafkan \email{michael.koohafkan@gmail.com}

}
