% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circGLMClassPlotFunctions.R
\name{plot.circGLM}
\alias{plot.circGLM}
\title{Plot circGLM object}
\usage{
\method{plot}{circGLM}(x, type = "trace", ...)
}
\arguments{
\item{x}{A \code{circGLM} object to be plotted.}

\item{type}{Character string giving the type of plotting. The options are
\code{"trace"}, \code{"tracestack"}, \code{"predict"}, \code{"meancompare"}
and \code{"meanboxplot"}.}

\item{...}{Additional arguments to be passed to subsequent plot functions.}
}
\description{
General plot function for \code{circGLM} objects, which dispatches the chosen
type of plotting to the corresponding function.
}
\examples{
plot(circGLM(th = rvmc(10, 1, 1)))

dat <- generateCircGLMData(n = 100, nconpred = 1, ncatpred = 1)
m   <- circGLM(th ~ ., dat, Q = 100, burnin = 0)

# Traceplot by default
plot(m)

# Traceplot stack
plot(m, type = "tracestack")

# Prediction plot
plot(m, type = "predict")

# Mean comparisons
plot(m, type = "meancompare")
plot(m, type = "meanboxplot")

}
\seealso{
\code{\link{plot_trace.circGLM}},
  \code{\link{plot_tracestack.circGLM}}, \code{\link{plot_predict.circGLM}},
  \code{\link{plot_meancompare.circGLM}} and
  \code{\link{plot_meanboxplot.circGLM}}.
}
