% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_build.R
\name{filter_build}
\alias{filter_build}
\title{Build the filter in CJA}
\usage{
filter_build(
  dataviewId = Sys.getenv("CJA_DATAVIEW_ID"),
  name = NULL,
  description = NULL,
  containers = NULL,
  rules = NULL,
  sequences = NULL,
  context = "hits",
  conjunction = "and",
  sequence = "in_order",
  sequence_context = "hits",
  exclude = FALSE,
  create_filter = FALSE,
  debug = FALSE,
  locale = "en_US",
  expansion = NULL
)
}
\arguments{
\item{dataviewId}{CJA data view id.  If an environment variable called \code{CJA_DATAVIEW_ID} exists
in \code{.Renviron} or elsewhere and no \code{dataviewId} argument is provided, then the \code{CJA_DATAVIEW_ID} value will
be used. Use \code{\link[=cja_get_dataviews]{cja_get_dataviews()}} to get a list of available \code{dataviewId}. Required}

\item{name}{This is the name of the new filter (required)}

\item{description}{This is the description of the filter (required)}

\item{containers}{List of the container(s) that make up the filter. Containers
are list objects created using the \code{\link[=filter_con]{filter_con()}} function.}

\item{rules}{List of the rules to create a filter. Rules are
list objects created using the \code{filter_rule()} function.}

\item{sequences}{List of the predicate(s) and sequence container(s) that are
combined to make a filter. Sequence containers are list objects created using
the \code{filter_seq()} function.}

\item{context}{Defines the level that the filter logic should operate on. Valid
values are visitors, visits, and hits. See Details}

\item{conjunction}{This will tell how the different containers and rules
should be compared. Use either 'and' or 'or'.}

\item{sequence}{Used to define if the filter should be 'in_order' (default),
'after', or 'before' the sequence of events}

\item{sequence_context}{Used to define the sequential items context which
should be below the container context. ex. if container context is visitors
then the sequence_context should be visits or hits}

\item{exclude}{Excludes the main container which will include all rules.
Only used when the rule arguments are used.}

\item{create_filter}{Used to determine if the filter should be created in the
UI or if the definition should be returned to be used in a freeform
table API call as a global filter. Default is FALSE, which means the segment
json string will be returned and the segment will not be created in the UI.}

\item{debug}{This enables the api call information to show in the console for
help with debugging issues. default is FALSE}

\item{locale}{Locale. Default "en_US"}

\item{expansion}{Comma-delimited list of additional filter metadata fields to
include on response. See Detail section for available options}
}
\value{
If the filter validates it will return a data frame of the newly
created filter id along with some other basic meta data. If it returns and
error then the error response will be returned to help understand what needs
to be corrected. If the argument \code{create_filter} is set to FALSE, the json string
will be returned in list format.
}
\description{
This function combines rules and/or containers and then makes the post
call to create the filter in CJA.
}
\details{
\strong{Context}
The rules in a filter have a context that specify the level of operation.
The context can be visitors, visits or hits.
As an example, let's build a filter rule where revenue is greater than 0 (meaning
a purchase took place) and change the context to see how things change.
If the context is set to visitors, the filter includes all hits from visitors
that have a purchase of some kind during a visit. This is useful in analyzing
customer behavior in visits leading up to a purchase and possibly behavior after
a purchase.
the context is set to visits, the filter includes all hits from visits where
a purchase occurred. This is useful for seeing the behavior of a visitor in
immediate page views leading up to the purchase.
If the context is set to hit, the filter only includes hits where a purchase
occurred, and no other hits. This is useful in seeing which products were most popular.
In the above example, the context for the container listed is hits. This means
that the container only evaluates data at the hit level, (in contrast to visit
or visitor level). The rows in the container are also at the hit level.

\strong{Expansion}
Available option include the following:
"compatibility" "definition" "internal" "modified" "isDeleted" "definitionLastModified"
"createdDate" "recentRecordedAccess" "performanceScore" "owner" "dataId" "ownerFullName"
"dataName" "sharesFullName" "approved" "favorite" "shares" "tags" "usageSummary"
"usageSummaryWithRelevancyScore"
}
