% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prauc_table.SuperLearner.R
\name{prauc_table.SuperLearner}
\alias{prauc_table.SuperLearner}
\title{Table of PR-AUCs from SuperLearner result}
\usage{
\method{prauc_table}{SuperLearner}(x, y = x$Y, sort = TRUE, ...)
}
\arguments{
\item{x}{SuperLearner object}

\item{y}{Outcome vector, if not already added to SL object.}

\item{sort}{Sort table by order of AUC.}

\item{...}{Any additional unused arguments, due to the prauc_table generic.}
}
\value{
Dataframe table with PR-AUCs.
}
\description{
Calculates precision-recall AUC for each learner in the SuperLearner.
}
\examples{
library(SuperLearner)
library(ck37r)

data(Boston, package = "MASS")

set.seed(1)
sl = SuperLearner(Boston$chas, subset(Boston, select = -chas),
                  family = binomial(),
                  SL.library = c("SL.mean", "SL.glm"))

prauc_table(sl, y = Boston$chas)

}
\references{
Polley EC, van der Laan MJ (2010) Super Learner in Prediction. U.C. Berkeley
Division of Biostatistics Working Paper Series. Paper 226.
http://biostats.bepress.com/ucbbiostat/paper266/

van der Laan, M. J., Polley, E. C. and Hubbard, A. E. (2007) Super Learner.
Statistical Applications of Genetics and Molecular Biology, 6, article 25.
http://www.degruyter.com/view/j/sagmb.2007.6.issue-1/sagmb.2007.6.1.1309/sagmb.2007.6.1.1309.xml
}
