% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeDistMat.R
\name{computeDistMat}
\alias{computeDistMat}
\title{Compute a distance matrix for functional observations}
\usage{
computeDistMat(x, y = NULL, method = "Euclidean", dmin = 0, dmax = 1,
  dmin1 = 0, dmax1 = 1, dmin2 = 0, dmax2 = 1, t1 = 0, t2 = 1,
  .poi = seq(0, 1, length.out = ncol(x)), custom.metric = function(x, y, lp
  = 2, ...) {     return(sum(abs(x - y)^lp)^(1/lp)) }, a = NULL, b = NULL,
  c = NULL, lambda = 0, ...)
}
\arguments{
\item{x}{[\code{matrix}]\cr
matrix containing the functional observations as rows.}

\item{y}{[\code{matrix}]\cr
see \code{x}. The default \code{NULL} uses \code{y = x}.}

\item{method}{[\code{character(1)}]\cr
 character string describing the distance function to be used. For a full list
 execute \code{\link{metricChoices}()}.
\describe{
 \item{\code{Euclidean}}{equals \code{Lp} with \code{p = 2}. This is the default.}
 \item{\code{Lp, Minkowski}}{the distance for an Lp-space, takes \code{p} as
 an additional argument in \code{...}.}
 \item{\code{Manhattan}}{equals \code{Lp} with \code{p = 1}.}
 \item{\code{supremum, max, maximum}}{equals \code{Lp} with \code{p = Inf}.
 The supremal pointwise difference between the curves.}
 \item{\code{and ...}}{all other available measures for \code{\link[proxy]{dist}}.}
 \item{\code{shortEuclidean}}{Euclidean distance on a limited part of the domain.
 Additional arguments \code{dmin} and \code{dmax} can be specified in
 \code{...}, giving
 the position of the first and the last point to use of an evenly spaced
 sequence from \code{0} to \code{1} of length \code{length(grid)}.
 The default values are \code{dmin = o} and \code{dmax = 1},
 which results in the Euclidean distance on the entire domain.}
 \item{\code{mean}}{the absolute similarity of the overall mean values of
 the observations.}
 \item{\code{relAreas}}{the difference of the relation of two areas on parts
 of the domain given by \code{dmin1} to \code{dmax1} and \code{dmin2} to
 \code{dmax2}. They are defined analogously to \code{dmin} and \code{dmax}
 and take the same default values.}
 \item{\code{jump}}{the similarity of jump heights at points \code{t1} and \code{t2},
 i.e. \code{x[t1 * length(x)] - x[t2 * length(x)]} for every functional observation \code{x}.
 The points \code{t1} and \code{t2} are the positions  in an evenly spaced sequence
 from \code{0} to \code{1} of length \code{length(grid)} for which to compare the
 jump height. The default values are \code{t1 = 0} and \code{t2 = 1}.}
 \item{\code{globMax}}{the difference of the curves global maxima.}
 \item{\code{globMin}}{the difference of the curves global minima.}
 \item{\code{points}}{the mean absolute differences at certain observation
 points \code{.poi}, also  called "points of impact". These are specified as
 a vector \code{.poi} of arbitrary length with values between \code{0}
 and \code{1}, encoding the the index of the points of observations.
 The default value is \code{.poi = seq(0, 1, length.out = length(grid))}, which results in the Manhattan
 distance.}
 \item{\code{custom.metric}}{your own semimetric will be used. Specify your
 own distance function in the argument \code{custom.metric}.}
 \item{\code{amplitudeDistance,phaseDistance}}{The amplitude distance or
 phase distance as described in
 Srivastava, A. and E. P. Klassen (2016). Functional and Shape Data Analysis. Springer.
 }
 \item{\code{FisherRao, elasticMetric}}{the elastic distance of the square
 root velocity of the curves as described in Srivastava and Klassen (2016).
 This equates to the Fisher Rao metric.}
 \item{\code{elasticDistance}}{weighted mean of the amplitude and the phase
 distance using the implementation in \code{\link[fdasrvf]{elastic.distance}}.
 Additional arguments are the numeric the penalization parameters \code{a,b,c}
 for the amplitude distance (\code{a^2}) and the phase distance (\code{b^2}).
 The default values are \code{a = 1/2, b = 1}.
 Alternatively \code{c} denotes the ratio of \code{2*a} and \code{b}.
 \code{lambda} is the additional penalization parameter for the warping
 allowed before calculating the elastic distance. The default is 1.}
\item{\code{rucrdtw, rucred}}{Dynamic Time Warping Distance and Euclidean Distance
 from package \code{\link{rucrdtw}}. Implemented in Boersch-Supan (2016) and
 originally described in Rakthanmanon et al. (2012).}
 }}

\item{dmin, dmax, dmin1, dmax1, dmin2, dmax2}{[\code{integer(1)}]\cr
encode the indices used to define subspaces for
\code{method \%in\% c("shortEuclidean", "relAreas")}
as numeric values between 0 and 1, where 0 encodes \code{grid[1]} and
1 encodes \code{grid[length(grid)]}.}

\item{t1, t2}{[\code{numeric(1)}]\cr
encode the position of the points for which to compare the jump heights in
\code{method = "jump"} as numeric values between 0 and 1, see \code{dmin}.}

\item{.poi}{[\code{numeric(1 to ncol(x))}]\cr
numeric vector of length arbitrary length taking numeric values
between 0 and 1, denoting the
position of the points of interest for \code{method = "points"}.
The default value is \code{.poi = seq(0, 1, length.out = length(grid))},
which results in the Manhattan distance.}

\item{custom.metric}{[\code{function(x, y, ...)}]\cr
a function specifying how to compute the distance between
two functional observations (= numeric vectors of the same length)
\code{x} and \code{y}. It can handle additional arguments in \code{...}.
The default is the Euclidean distance (equals Minkwoski distance
with \code{lp = 2}). Used for \code{method = "custom.metric"}.}

\item{a, b, c}{[\code{numeric(1)}]\cr
weights of the amplitude distance (\code{a}) and the phase distance (\code{b})
in a semimetric that combines them by addition.
Used for \code{method == 'elasticDistance'}.}

\item{lambda}{[\code{numeric(1)}]\cr
penalization parameter for the warping allowed before calculating the
elastic distance.
Default value is 0. Large values imply less (no) warping, small values
imply more warping.
Used for \code{method \%in\% c('elastic', 'SRV')}.}

\item{...}{additional parameters to the (semi-)metrics.}
}
\value{
a matrix of dimensions \code{nrow(x)} by \code{nrow(y)} containing the
  distances of the functional observations contained in \code{x} and \code{y},
  if \code{y} is specified. Otherwise a matrix containing the distances of all
  functional observations within \code{x} to each other.
}
\description{
This mainly internal function offers a unified framework to access the
\code{\link[proxy]{dist}} function from the \code{proxy} package and additional
(semi-)metrics.
}
\references{
Boersch-Supan (2016). rucrdtw: Fast time series subsequence
search in R. The Journal of Open Source Software
URL http://doi.org/10.21105/joss.00100

Fuchs, K., J. Gertheiss, and G. Tutz (2015):
Nearest neighbor ensembles for functional data with interpretable feature selection.
Chemometrics and Intelligent Laboratory Systems 146, 186 - 197.

Rakthanmanon, Thanawin, et al.
"Searching and mining trillions of time series subsequences under dynamic time warping."
Proceedings of the 18th ACM SIGKDD international conference on Knowledge discovery and data mining.
ACM, 2012.

Srivastava, A. and E. P. Klassen (2016). Functional and Shape Data Analysis. Springer.
}
