% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctitem.R
\name{ctitem}
\alias{ctitem}
\title{Classical test theory item statistics}
\usage{
ctitem(
  x,
  key = NULL,
  categories = NULL,
  wt = NULL,
  listwise = FALSE,
  recScore = TRUE
)
}
\arguments{
\item{x}{a data frame or matrix. For multiple choice items, columns can be
numeric or strings and keys should be provided. For polytomous items,
all columns should be numeric.}

\item{key}{a vector indicating the keys to score the data. If \code{NULL}
items are assumed as polytomous.
Default is \code{NULL}.}

\item{categories}{a vector indicating all possible categories.
If \code{NULL}, this vector will be created with all the non-NA
values present in \code{x}. Default is \code{NULL}.}

\item{wt}{a numeric vector of total weights. Default is \code{NULL}.}

\item{listwise}{only consider complete data (remove rows with NAs).
Defaulft is \code{FALSE}.}

\item{recScore}{a logical value indicating if the total score for
should be calculated based only on valid values. Thus,
if \code{TRUE}: \code{rowMeans(x,na.rm = TRUE)*apply(x,1L,function(k) sum(!is.na(k)))};
if \code{FALSE}: \code{rowMeans(x,na.rm = TRUE)*ncol(x)}. Defaulft is \code{TRUE}.
If \code{listwise}, this argument is meaningless.}
}
\value{
A data frame with item statistics.
}
\description{
Calculates several item statistics, including: item mean,
frequencies, proportions,
valid proportions, and correlations between item responses and the total score.
}
\details{
If keys are provided, items are assume as dichotomous and
transformed into 1s and 0s, where 1s are correct
answers. Then, point-biserial correlations are estimated between the item
and the total score (PBtotal), the item and the score without the item
(PBrest), between each response category and the total score.

If keys are not provided, data must be numeric,
items are assumed as polytomous and data will not be transformed.
For polytomous, Pearson's correlations are estimated between the item
and the total score (PEtotal), the item and the score without the item
(PErest), between each response category and the total score.
}
\examples{
data(dichodata)
data(polydata)
data(dichokey)

# Data preparation
## Random weights creation
set.seed(1919)
wt <- sample(x = 1:4, size = nrow(dichodata), replace = TRUE)

# Item analysis for multiple choice items
ctitem(x = dichodata, key = dichokey, categories = c('A','B','C','D'), wt = wt)

# Item analysis for polytomous items
ctitem(x = polydata, key = NULL, wt = wt)

}
