#' Annotation of Barack Obama's State of the Union Addresses
#'
#' Parsed text from all eight State of the Union addresses given by
#' Barack Obama.
#'
#' @name obama
#' @docType data
#' @references \url{http://www.presidency.ucsb.edu/sou.php}
#' @keywords data
NULL

#' Universal Dependency Frequencies
#'
#' The language-specific frequency of universal dependency codes as given
#' in standard treebank corpora. Frequencies are multiplied by 100.
#'
#' @name dep_frequency
#' @docType data
#' @references \url{http://universaldependencies.org/}
#' @keywords data
NULL

#' Universal Part of Speech Code Frequencies
#'
#' The language-specific frequency of universal part of speech codes as given
#' in standard treebank corpora. Frequencies are multiplied by 100.
#'
#' @name pos_frequency
#' @docType data
#' @references \url{http://universaldependencies.org/}
#' @keywords data
NULL

#' Most frequent English words
#'
#' A dataset of the 150k most frequently used English words, extracted by
#' Peter Norvig from the Google Web Trillion Word Corpus. Frequencies are
#' multiplied by 100.
#'
#' @name word_frequency
#' @docType data
#' @references \url{http://norvig.com/ngrams/}
#' @keywords data
NULL
