% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{function_checks}
\alias{function_checks}
\alias{check_num_arguments}
\alias{check_nesting_depth}
\alias{check_num_lines}
\alias{check_num_lines_of_code}
\alias{check_line_width}
\alias{check_return}
\title{Function Checks}
\usage{
check_num_arguments(object, max_num_arguments = gco("max_num_arguments"))

check_nesting_depth(object, max_nesting_depth = gco("max_nesting_depth"))

check_num_lines(object, max_lines = gco("max_lines"))

check_num_lines_of_code(object, max_lines_of_code = gco("max_lines_of_code"))

check_line_width(object, max_line_width = gco("max_line_width"))

check_return(object, check_return = gco("check_return"))
}
\arguments{
\item{object}{The function to be checked.
Should have been sourced with keep.source = TRUE (see
\code{\link{get_function_body}}).}

\item{max_num_arguments}{The maximum number of arguments accepted.
Set (preferably via \code{\link{set_cleanr_options}}) to \code{NULL} or
\code{FALSE} to disable the check.}

\item{max_nesting_depth}{The maximum nesting depth accepted.
Set (preferably via \code{\link{set_cleanr_options}}) to \code{NULL} or
\code{FALSE} to disable the check.}

\item{max_lines}{The maximum number of lines accepted.
Set (preferably via \code{\link{set_cleanr_options}}) to \code{NULL} or
\code{FALSE} to disable the check.}

\item{max_lines_of_code}{The maximum number of lines of code accepted.
Set (preferably via \code{\link{set_cleanr_options}}) to \code{NULL} or
\code{FALSE} to disable the check.}

\item{max_line_width}{The maximum line width accepted.
Set (preferably via \code{\link{set_cleanr_options}}) to \code{NULL} or
\code{FALSE} to disable the check.}

\item{check_return}{Set (preferably via \code{\link{set_cleanr_options}}) to \code{NULL} or
\code{FALSE} to disable the check.}
}
\value{
\code{\link[base:invisible]{Invisibly}} \code{\link{TRUE}},
but see \emph{Details}.
}
\description{
A set of tiny functions to check that functions adhere to a layout style.
A function should have a clear layout, it should
\itemize{
  \item not have too many arguments,
  \item not have too many levels of nesting,
  \item neither have too many lines nor
  \item have too many lines of code,
  \item not have lines too wide and
  \item explicitly \code{\link{return}} an object.
}
}
\details{
In case of a fail all \code{\link{function_checks}} \code{\link{throw}} a
condition of class c("cleanr", "error", "condition").
}
\section{Warning}{
 \code{\link{check_return}} just \code{\link{grep}}s for a
for a line starting with a \code{\link{return}} statement (ah, see the code
for the real thing).
This does not ensure that \emph{all} \code{\link{return}} paths from the
function are explicit and it may miss a \code{\link{return}} path after a
semicolon.
It just checks if you use \code{\link{return}} at all.
}

\examples{
print(cleanr::check_num_arguments(cleanr::check_num_arguments))
print(cleanr::check_nesting_depth(cleanr::check_nesting_depth))
print(cleanr::check_num_lines(cleanr::check_num_lines))
print(cleanr::check_num_lines_of_code(cleanr::check_num_lines_of_code))
print(cleanr::check_return(cleanr::check_return))
# R reformats functions on import (see
# help(get_function_body, package = "cleanr")), so we need 90 characters:
print(cleanr::check_line_width(cleanr::check_line_width,
                               max_line_width = 90))
}
\seealso{
Other check functions: 
\code{\link{file_checks}}
}
\concept{check functions}
