% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive.R
\name{fix.numerics}
\alias{fix.numerics}
\title{Fix numeric data}
\usage{
fix.numerics(x, k = 8, max.NA = 0.2, info = TRUE)
}
\arguments{
\item{x}{A data.frame}

\item{k}{Minimum number of different values to be considered numerical}

\item{max.NA}{Maximum allowed proportion of NA values created by coercion}

\item{info}{Add generated missing values an excluded variable information as attributes}
}
\description{
Fixes numeric data
}
\examples{
mydata<-data.frame(Numeric1=c(7.8, 9.2, 5.4, 3.3, "6,8", "3..3"),
                   Numeric2=c(3.1, 1.2, "3.s4", "a48,s5", 7, "6,,4"))
report(mydata)
report(fix.numerics(mydata, k=5))
}
