% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive.R
\name{fix.levels}
\alias{fix.levels}
\title{Fix levels}
\usage{
fix.levels(
  data,
  factor_name,
  levels = NULL,
  plot = FALSE,
  k = ifelse(!is.null(levels), length(levels), 2),
  track = TRUE
)
}
\arguments{
\item{data}{data.frame with the factor to fix}

\item{factor_name}{Name of the factor to fix (as character)}

\item{levels}{Optional vector with the levels names}

\item{plot}{Optional: Plot cluster dendrogram?}

\item{k}{Number of levels for clustering}

\item{track}{Keep track of changes?}
}
\description{
Fixes levels of a factor
}
\examples{
mydata <- data.frame(factor1=factor(c("Control", "Treatment", "Tretament", "Tratment", "treatment",
"teatment", "contrl", "cntrol", "CONTol", "not available", "na")))
fix.levels(mydata, "factor1", k=4, plot=TRUE)   #Chose k to select matching levels
fix.levels(mydata, "factor1", levels=c("Control", "Treatment"), k=4)
}
