% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MarkovChain.r
\docType{methods}
\name{randomClicks-methods}
\alias{randomClicks}
\alias{randomClicks,MarkovChain-method}
\alias{randomClicks-methods}
\title{Generates a Sequence of Clicks}
\usage{
randomClicks(object, startPattern, dist)
}
\arguments{
  \item{object}{The \code{MarkovChain} used for generating
  the next click(s)} \item{startPattern}{\code{Pattern}
  containing the first clicks of a user. A \code{Pattern}
  object with an empty sequence is also possible.}
  \item{dist}{(Optional) The number of clicks that should be
  generated (default is 1).}
}
\description{
Generates a Sequence of Clicks
}
\section{Methods}{
  \describe{ \item{list("signature(object = \"MarkovChain
  \")")}{ Generates a sequence of clicks by randomly walking
  through the transition graph of a given \code{MarkovChain}
  object. } }
}
\examples{
# fitting a simple Markov chain and predicting the next click
clickstreams <- c("User1,h,c,c,p,c,h,c,p,p,c,p,p,o",
               "User2,i,c,i,c,c,c,d",
               "User3,h,i,c,i,c,p,c,c,p,c,c,i,d",
               "User4,c,c,p,c,d",
               "User5,h,c,c,p,p,c,p,p,p,i,p,o",
               "User6,i,h,c,c,p,p,c,p,c,d")
csf <- tempfile()
writeLines(clickstreams, csf)
cls <- readClickstreams(csf, header = TRUE)
mc <- fitMarkovChain(cls)
startPattern <- new("Pattern", sequence = c("h", "c"))
predict(mc, startPattern)
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\seealso{
\code{\link{fitMarkovChain}}
}
\keyword{methods}

